/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import jakarta.xml.ws.handler.Handler;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class HandlerTracker {
    private static Vector<String> messages1 = new Vector();
    private static Vector<String> messages2 = new Vector();
    private static Vector<String> messages3 = new Vector();
    private static Vector<String> messages4 = new Vector();
    private static Vector<Handler> handlers = new Vector();
    private static Vector<String> throwables = new Vector();
    private static Map map = new Hashtable();

    public static Object get(String key) {
        return map.get(key);
    }

    public static void put(String key, Object value) {
        map.put(key, value);
    }

    public static boolean clearMap() {
        map = new Hashtable();
        return true;
    }

    public static String getId(Handler handler) {
        return handler.getClass().getName();
    }

    public static String getIdNameOnly(Handler handler) {
        String name = HandlerTracker.getId(handler);
        int i = name.lastIndexOf(".");
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static void reportInit(Handler handler, String methodName) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + "." + methodName + "()"));
        if (!handlers.contains(handler)) {
            handlers.add(handler);
        }
        messages1.add(HandlerTracker.getIdNameOnly(handler) + "." + methodName + "()");
    }

    public static void reportDestroy(Handler handler, String methodName) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + "." + methodName + "()"));
        messages1.add(HandlerTracker.getIdNameOnly(handler) + "." + methodName + "()");
    }

    public static void reportGetHeaders(Handler handler) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + ".getHeaders()"));
        messages1.add(HandlerTracker.getIdNameOnly(handler) + ".getHeaders()");
    }

    public static void reportHandleFault(Handler handler) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + ".handleFault()"));
        messages1.add(HandlerTracker.getIdNameOnly(handler) + ".handleFault()");
    }

    public static void reportClose(Handler handler) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + ".close()"));
        messages1.add(HandlerTracker.getIdNameOnly(handler) + ".close()");
    }

    public static void reportComment(Handler handler, String comment) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + " " + comment));
        messages1.add(HandlerTracker.getIdNameOnly(handler) + " " + comment);
    }

    public static void reportHandleMessage(Handler handler, String direction) {
        TestUtil.logTrace((String)("HandlerTracker: " + HandlerTracker.getIdNameOnly(handler) + ".handleMessage().do" + direction + "()"));
        messages1.add(HandlerTracker.getIdNameOnly(handler) + ".handleMessage().do" + direction + "()");
    }

    public static void reportPut(Handler h, String p, String v) {
        TestUtil.logTrace((String)("HandlerTracker: reportPut()=" + HandlerTracker.getIdNameOnly(h) + ".MessageContext.put(" + p + "," + v + ")"));
        messages2.add(HandlerTracker.getIdNameOnly(h) + ".MessageContext.put(" + p + "," + v + ")");
    }

    public static void reportSetScope(Handler h, String p, String s) {
        TestUtil.logTrace((String)("HandlerTracker: reportSetScope()=" + HandlerTracker.getIdNameOnly(h) + ".MessageContext.setPropertyScope(" + p + "," + s + ")"));
        messages2.add(HandlerTracker.getIdNameOnly(h) + ".MessageContext.setPropertyScope(" + p + "," + s + ")");
    }

    public static void reportProperties(Handler h, String d, String p, String v) {
        TestUtil.logTrace((String)("HandlerTracker: reportProperties()=" + d + HandlerTracker.getIdNameOnly(h) + ".MessageContext.getProperty(" + p + ")=" + v));
        messages2.add(d + HandlerTracker.getIdNameOnly(h) + ".MessageContext.getProperty(" + p + ")=" + v);
    }

    public static void reportGet(Handler h, String p, String v) {
        TestUtil.logTrace((String)("HandlerTracker: reportGet()=" + HandlerTracker.getIdNameOnly(h) + ".MessageContext.getProperty(" + p + ")=" + v));
        messages2.add(HandlerTracker.getIdNameOnly(h) + ".MessageContext.getProperty(" + p + ")=" + v);
    }

    public static void reportGetScope(Handler h, String p, String v) {
        TestUtil.logTrace((String)("HandlerTracker: reportGetScope()=" + HandlerTracker.getIdNameOnly(h) + ".MessageContext.getPropertyScope(" + p + ")=" + v));
        messages2.add(HandlerTracker.getIdNameOnly(h) + ".MessageContext.getPropertyScope(" + p + ")=" + v);
    }

    public static void reportSMCGetMessage(Handler h, String direction, String s) {
        TestUtil.logTrace((String)("HandlerTracker: reportSMCGetMessage()=" + direction + HandlerTracker.getIdNameOnly(h) + ".SOAPMessageContext.getMessage()=" + s));
        messages3.add(direction + HandlerTracker.getIdNameOnly(h) + ".SOAPMessageContext.getMessage()=" + s);
    }

    public static void reportSMCSetMessage(Handler h, String direction) {
        messages3.add(direction + HandlerTracker.getIdNameOnly(h) + ".SOAPMessageContext.setMessage() was called");
    }

    public static void reportSMCGetRoles(Handler h, String direction, Set<String> set) {
        Object[] o = set.toArray();
        StringBuffer s = new StringBuffer("|");
        for (int i = 0; i <= o.length - 1; ++i) {
            s.append(o[i]);
        }
        s.append("|");
        messages3.add(direction + HandlerTracker.getIdNameOnly(h) + ".SOAPMessageContext.getRoles()=" + s);
    }

    public static void reportSMCGetHeaders(Handler h, String direction, Object[] o) {
        StringBuffer s = new StringBuffer("|");
        for (int i = 0; i <= o.length - 1; ++i) {
            s.append(o[i]);
        }
        s.append("|");
        messages3.add(direction + HandlerTracker.getIdNameOnly(h) + ".SOAPMessageContext.getHeaders()=" + s);
    }

    public static void reportLMCGetMessage(Handler h, String direction, String s) {
        TestUtil.logTrace((String)("HandlerTracker: reportLMCGetMessage()=" + direction + HandlerTracker.getIdNameOnly(h) + ".LogicalMessageContext.getMessage()=" + s));
        messages4.add(direction + HandlerTracker.getIdNameOnly(h) + ".LogicalMessageContext.getMessage()=" + s);
    }

    public static void reportThrowable(Handler handler, Throwable t) {
        TestUtil.logTrace((String)("HandlerTracker: reportThrowable(): " + HandlerTracker.getIdNameOnly(handler) + " " + t));
        throwables.add(HandlerTracker.getIdNameOnly(handler));
        throwables.add(t.toString());
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            throwables.add(ste[i].toString());
        }
    }

    public static void purge() {
        messages1.clear();
        messages2.clear();
        messages3.clear();
        messages4.clear();
        throwables.clear();
    }

    public static String[] getArrayMessages1() {
        String[] result = new String[messages1.size()];
        for (int i = 0; i < messages1.size(); ++i) {
            result[i] = messages1.elementAt(i);
        }
        return result;
    }

    public static List<String> getListMessages1() {
        return messages1;
    }

    public static String getMessages1() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < messages1.size(); ++i) {
            if (i + 1 == messages1.size()) {
                result.append(messages1.elementAt(i));
                continue;
            }
            result.append(messages1.elementAt(i) + "\n");
        }
        return result.toString();
    }

    public static String[] getArrayMessages2() {
        String[] result = new String[messages2.size()];
        for (int i = 0; i < messages2.size(); ++i) {
            result[i] = messages2.elementAt(i);
        }
        return result;
    }

    public static List<String> getListMessages2() {
        return messages2;
    }

    public static String getMessages2() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < messages2.size(); ++i) {
            if (i + 1 == messages2.size()) {
                result.append(messages2.elementAt(i));
                continue;
            }
            result.append(messages2.elementAt(i) + "\n");
        }
        return result.toString();
    }

    public static String[] getArrayMessages3() {
        String[] result = new String[messages3.size()];
        for (int i = 0; i < messages3.size(); ++i) {
            result[i] = messages3.elementAt(i);
        }
        return result;
    }

    public static List<String> getListMessages3() {
        return messages3;
    }

    public static String getMessages3() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < messages3.size(); ++i) {
            if (i + 1 == messages3.size()) {
                result.append(messages3.elementAt(i));
                continue;
            }
            result.append(messages3.elementAt(i) + "\n");
        }
        return result.toString();
    }

    public static String[] getArrayMessages4() {
        String[] result = new String[messages4.size()];
        for (int i = 0; i < messages4.size(); ++i) {
            result[i] = messages4.elementAt(i);
        }
        return result;
    }

    public static List<String> getListMessages4() {
        return messages4;
    }

    public static String getMessages4() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < messages4.size(); ++i) {
            if (i + 1 == messages4.size()) {
                result.append(messages4.elementAt(i));
                continue;
            }
            result.append(messages4.elementAt(i) + "\n");
        }
        return result.toString();
    }

    public static String[] getArrayThrowables() {
        String[] result = new String[throwables.size()];
        for (int i = 0; i < throwables.size(); ++i) {
            result[i] = throwables.elementAt(i);
        }
        return result;
    }

    public static List<Handler> getHandlerMessages() {
        return handlers;
    }

    public static void clearHandlers() {
        handlers.clear();
    }
}

