/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Address_;
import com.sun.ts.tests.jpa.common.schema30.Country;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Customer_;
import com.sun.ts.tests.jpa.common.schema30.Department;
import com.sun.ts.tests.jpa.common.schema30.Department_;
import com.sun.ts.tests.jpa.common.schema30.HardwareProduct;
import com.sun.ts.tests.jpa.common.schema30.Order_;
import com.sun.ts.tests.jpa.common.schema30.Product;
import com.sun.ts.tests.jpa.common.schema30.Util;
import com.sun.ts.tests.jpa.core.criteriaapi.CriteriaQuery.A;
import jakarta.persistence.Parameter;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupAData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupData");
        try {
            super.setup(args, p);
            this.removeATestData();
            this.createATestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupOrderData")
    public void fromClass() throws EETest.Fault {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(this.getEntityManager().getMetamodel().entity(com.sun.ts.tests.jpa.common.schema30.Order.class));
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 3;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size()));
                }
            } else {
                TestUtil.logErr((String)"Missing expected result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("fromClass failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void fromEntityType() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root p;
            Root order = cquery.from(this.getEntityManager().getMetamodel().entity(com.sun.ts.tests.jpa.common.schema30.Order.class));
            EntityType Order_ = order.getModel();
            Root exp = p = order;
            Expression type = p.type();
            if (type != null) {
                TestUtil.logTrace((String)"Path.type() returned non-null result");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Expected non-null Path.type()");
            }
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)p.get(Order_.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 3;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)("Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size()));
                }
            } else {
                TestUtil.logErr((String)"Missing expected result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("fromEntityType failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void select() throws EETest.Fault {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 3;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size()));
                }
            } else {
                TestUtil.logErr((String)"Missing expected result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("select test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void selectIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            TestUtil.logTrace((String)"Creating select using selection items with the same alias");
            try {
                CompoundSelection c = cbuilder.array(new Selection[]{customer.get("id").alias("SAMEALIAS"), customer.get("name").alias("SAMEALIAS")});
                cquery.select((Selection)c);
                TestUtil.logErr((String)"Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("selectIllegalArgumentException failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void multiselect() throws EETest.Fault {
        boolean pass = false;
        int expectedResultSize = 20;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            if (result.size() == 20) {
                TestUtil.logTrace((String)("Result size =" + result.size()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Received incorrect result size =" + result.size()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("multiselect test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void multiselectListTest() throws EETest.Fault {
        boolean pass = false;
        int expectedResultSize = 20;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            ArrayList<Path> list = new ArrayList<Path>();
            list.add(customer.get(Customer_.getSingularAttribute("id", String.class)));
            list.add(customer.get(Customer_.getSingularAttribute("name", String.class)));
            cquery.multiselect(list);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            if (result.size() == 20) {
                TestUtil.logTrace((String)("Result size =" + result.size()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Received incorrect result size =" + result.size()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("multiselectListTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void multiselectIllegalArgumentExceptionTest() throws EETest.Fault {
        Root customer;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        TestUtil.logMsg((String)"Testing multiselect invalid item");
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            TestUtil.logTrace((String)"Creating multiselect using selection array of items that do not exist");
            try {
                cquery.multiselect(new Selection[]{customer.get("doesnotexist").alias("ALIAS1"), customer.get("doesnotexist2").alias("ALIAS2")});
                TestUtil.logErr((String)"Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        TestUtil.logMsg((String)"Testing multiselect selection[]");
        cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            TestUtil.logTrace((String)"Creating multiselect using selection array of items with the same alias");
            Selection[] selection = new Selection[]{customer.get("id").alias("SAMEALIAS"), customer.get("name").alias("SAMEALIAS")};
            try {
                cquery.multiselect(selection);
                TestUtil.logErr((String)"Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        TestUtil.logMsg((String)"Testing multiselect List");
        cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            TestUtil.logTrace((String)"Creating multiselect using selection items with the same alias");
            try {
                ArrayList<Selection> list = new ArrayList<Selection>();
                list.add(customer.get("id").alias("SAMEALIAS"));
                list.add(customer.get("name").alias("SAMEALIAS"));
                cquery.multiselect(list);
                TestUtil.logErr((String)"Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"received expected IllegalArgumentException");
                pass3 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("multiselectIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void where() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 1;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size()));
                }
            } else {
                TestUtil.logErr((String)"Missing expected result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("where test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void createQueryCriteriaUpdateTest() throws EETest.Fault {
        boolean pass = false;
        String expected = "foobar";
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cquery = cbuilder.createCriteriaUpdate(Customer.class);
        Root customer = cquery.from(Customer.class);
        cquery.set(customer.get("name"), (Object)expected);
        cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"1"));
        this.getEntityManager().createQuery(cquery).executeUpdate();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        Customer actual = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
        if (actual == null) {
            TestUtil.logErr((String)"Received null result from find");
        } else if (actual.getName().equals(expected)) {
            TestUtil.logTrace((String)"Name was successfully updated");
            pass = true;
        } else {
            TestUtil.logErr((String)("Expected:" + expected + ", actual:" + actual.getName()));
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createQueryCriteriaUpdateTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void createQueryCriteriaDeleteTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cquery = cbuilder.createCriteriaDelete(Customer.class);
        Root customer = cquery.from(Customer.class);
        EntityType Customer_ = customer.getModel();
        cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
        this.getEntityManager().createQuery(cquery).executeUpdate();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        Customer actual = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
        if (actual != null) {
            TestUtil.logErr((String)("Expected null result from find, actual = " + actual.toString()));
        } else {
            TestUtil.logTrace((String)"Customer was successfully deleted");
            pass = true;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createQueryCriteriaDeleteTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void wherePredicateArrayTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(Integer.valueOf(this.customerRef[3].getId()));
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing initial query");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("name"), (Object)"Robert E. Bissett"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            TestUtil.logMsg((String)"Modify query but this change should not yet take effect");
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.home).get(Address_.zip), "%77"));
            Predicate[] predArray = new Predicate[]{cbuilder.like((Expression)customer.get(Customer_.name), "Karen%"), cbuilder.like((Expression)customer.get(Customer_.name), "%Tegan")};
            cquery.where(predArray);
            List result = tquery.getResultList();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            TestUtil.logMsg((String)"Now verify query change does take effect");
            actual.clear();
            expected.clear();
            result.clear();
            expected.add(Integer.valueOf(this.customerRef[5].getId()));
            tquery = this.getEntityManager().createQuery(cquery);
            result = tquery.getResultList();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
                TestUtil.logTrace((String)("Found id:" + c.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("wherePredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fromGetStringTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("name"), (Object)"Karen R. Tegan"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 1) {
                if (!((Customer)result.get(0)).getId().equals("6")) {
                    TestUtil.logErr((String)("Expected id:6, actual:" + ((Customer)result.get(0)).getId()));
                } else {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + result.size()));
                for (Customer c : result) {
                    TestUtil.logErr((String)("id:" + c.getId()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fromGetStringTest failed");
        }
    }

    public void fromGetStringIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            try {
                cquery.from(A.class).get("value").get("value2");
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fromGetStringIllegalStateExceptionTest failed");
        }
    }

    public void pathGetStringIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            Path path = cquery.from(A.class).get("value");
            try {
                path.get("value2");
                TestUtil.logErr((String)"IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("pathGetStringIllegalStateExceptionTest failed");
        }
    }

    public void fromGetStringIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            try {
                cquery.from(A.class).get("doesnotexist");
                TestUtil.logErr((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException ise) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fromGetStringIllegalArgumentExceptionTest failed");
        }
    }

    public void fromGetModelTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        String expected = "com.sun.ts.tests.jpa.common.schema30.Customer";
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            EntityType bind = cquery.from(Customer.class).getModel();
            String name = bind.getBindableJavaType().getName();
            if (name.equals(expected)) {
                TestUtil.logTrace((String)("Received expected name:" + name));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected:" + expected + ", actual:" + name));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fromGetModelTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void fromGetParentPathTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        String expected = "com.sun.ts.tests.jpa.common.schema30.Order";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            Root order;
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root from = order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Path path = from.getParentPath();
            if (path == null) {
                TestUtil.logTrace((String)"Received expected null");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected:null, actual:" + path));
            }
            Path p = from.join(Order_.creditCard).getParentPath();
            if (p != null) {
                String name = p.getModel().getBindableJavaType().getName();
                if (name != null) {
                    if (name.equals(expected)) {
                        TestUtil.logTrace((String)("Received expected name:" + name));
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Expected:" + expected + ", actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"Null was returned for p.getModel().getBindableJavaType().getName()");
                    TestUtil.logErr((String)("p.getModel:" + p.getModel()));
                    TestUtil.logErr((String)("p.getModel().getBindableJavaType():" + p.getModel().getBindableJavaType()));
                    TestUtil.logErr((String)("p.getModel().getBindableJavaType().getName():" + p.getModel().getBindableJavaType().getName()));
                }
            } else {
                TestUtil.logErr((String)"getParentPath() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("fromGetParentPathTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void groupBy() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<ExpectedResult> expected = new ArrayList<ExpectedResult>();
        expected.add(new ExpectedResult("CHA", "4"));
        expected.add(new ExpectedResult("GBR", "2"));
        expected.add(new ExpectedResult("IRE", "2"));
        expected.add(new ExpectedResult("JPN", "1"));
        expected.add(new ExpectedResult("USA", "11"));
        try {
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            Metamodel mm = this.getEntityManagerFactory().getMetamodel();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(Country.class);
            cquery.multiselect(new Selection[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), cbuilder.count((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)))});
            cquery.groupBy(new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))});
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            int i = 0;
            int passCount1 = 0;
            int passCount2 = 0;
            if (result.size() == expected.size()) {
                for (Tuple actual : result) {
                    TestUtil.logTrace((String)("code=" + actual.get(0) + ", count=" + actual.get(1)));
                    if (!actual.get(0).equals(((ExpectedResult)expected.get((int)i)).arg1)) {
                        TestUtil.logErr((String)("Expected: " + ((ExpectedResult)expected.get((int)i)).arg1 + ", actual:" + actual.get(0)));
                    } else {
                        ++passCount1;
                    }
                    if (!actual.get(1).equals(Long.parseLong(((ExpectedResult)expected.get((int)i)).arg2))) {
                        TestUtil.logErr((String)("Expected: " + ((ExpectedResult)expected.get((int)i)).arg2 + ", actual:" + actual.get(1)));
                    } else {
                        ++passCount2;
                    }
                    ++i;
                }
                if (passCount1 == expected.size()) {
                    pass1 = true;
                }
                if (passCount2 == expected.size()) {
                    pass2 = true;
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of entries, expected:" + expected.size() + ", actual:" + result.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception groupBy: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("groupBy failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void groupByExpArrayTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<ExpectedResult> expected = new ArrayList<ExpectedResult>();
        expected.add(new ExpectedResult("CHA", "13"));
        expected.add(new ExpectedResult("CHA", "18"));
        expected.add(new ExpectedResult("CHA", "19"));
        expected.add(new ExpectedResult("CHA", "20"));
        expected.add(new ExpectedResult("GBR", "11"));
        expected.add(new ExpectedResult("GBR", "16"));
        expected.add(new ExpectedResult("IRE", "12"));
        expected.add(new ExpectedResult("IRE", "17"));
        expected.add(new ExpectedResult("JPN", "14"));
        expected.add(new ExpectedResult("USA", "1"));
        expected.add(new ExpectedResult("USA", "10"));
        expected.add(new ExpectedResult("USA", "15"));
        expected.add(new ExpectedResult("USA", "2"));
        expected.add(new ExpectedResult("USA", "3"));
        expected.add(new ExpectedResult("USA", "4"));
        expected.add(new ExpectedResult("USA", "5"));
        expected.add(new ExpectedResult("USA", "6"));
        expected.add(new ExpectedResult("USA", "7"));
        expected.add(new ExpectedResult("USA", "8"));
        expected.add(new ExpectedResult("USA", "9"));
        try {
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            Metamodel mm = this.getEntityManagerFactory().getMetamodel();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(Country.class);
            Selection[] selection = new Selection[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), customer.get(Customer_2.getSingularAttribute("id", String.class))};
            Expression[] expressionArray1 = new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))};
            Expression[] expressionArray2 = new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), customer.get(Customer_2.getSingularAttribute("id", String.class))};
            cquery.multiselect(selection);
            cquery.groupBy(expressionArray1);
            cquery.groupBy(expressionArray2);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))), cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (TestUtil.traceflag) {
                for (Tuple actual : result) {
                    TestUtil.logTrace((String)("Actual - code=" + actual.get(0) + ", id=" + actual.get(1)));
                }
            }
            int i = 0;
            int passCount1 = 0;
            int passCount2 = 0;
            for (Tuple actual : result) {
                TestUtil.logTrace((String)("verifying: code=" + actual.get(0) + ", id=" + actual.get(1)));
                if (!actual.get(0).equals(((ExpectedResult)expected.get(i)).getArg1())) {
                    TestUtil.logErr((String)("Expected getArg1:" + ((ExpectedResult)expected.get(i)).getArg1() + ", actual.get(0):" + actual.get(0)));
                } else {
                    ++passCount1;
                }
                if (!actual.get(1).equals(((ExpectedResult)expected.get(i)).getArg2())) {
                    TestUtil.logErr((String)("Expected getArg2:" + ((ExpectedResult)expected.get(i)).getArg2() + ", actual.get(1):" + actual.get(1)));
                } else {
                    ++passCount2;
                }
                ++i;
            }
            if (passCount1 == expected.size()) {
                pass1 = true;
            }
            if (passCount2 == expected.size()) {
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("groupByExpArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void groupByListTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<ExpectedResult> expected = new ArrayList<ExpectedResult>();
        expected.add(new ExpectedResult("CHA", "13"));
        expected.add(new ExpectedResult("CHA", "18"));
        expected.add(new ExpectedResult("CHA", "19"));
        expected.add(new ExpectedResult("CHA", "20"));
        expected.add(new ExpectedResult("GBR", "11"));
        expected.add(new ExpectedResult("GBR", "16"));
        expected.add(new ExpectedResult("IRE", "12"));
        expected.add(new ExpectedResult("IRE", "17"));
        expected.add(new ExpectedResult("JPN", "14"));
        expected.add(new ExpectedResult("USA", "1"));
        expected.add(new ExpectedResult("USA", "10"));
        expected.add(new ExpectedResult("USA", "15"));
        expected.add(new ExpectedResult("USA", "2"));
        expected.add(new ExpectedResult("USA", "3"));
        expected.add(new ExpectedResult("USA", "4"));
        expected.add(new ExpectedResult("USA", "5"));
        expected.add(new ExpectedResult("USA", "6"));
        expected.add(new ExpectedResult("USA", "7"));
        expected.add(new ExpectedResult("USA", "8"));
        expected.add(new ExpectedResult("USA", "9"));
        try {
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            Metamodel mm = this.getEntityManagerFactory().getMetamodel();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(Country.class);
            Selection[] selection = new Selection[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), customer.get(Customer_2.getSingularAttribute("id", String.class))};
            ArrayList<Path> groupByList1 = new ArrayList<Path>();
            groupByList1.add(customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            ArrayList<Path> groupByList2 = new ArrayList<Path>();
            groupByList2.add(customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            groupByList2.add(customer.get(Customer_2.getSingularAttribute("id", String.class)));
            cquery.multiselect(selection);
            cquery.groupBy(groupByList1);
            cquery.groupBy(groupByList2);
            ArrayList<Order> orderList1 = new ArrayList<Order>();
            orderList1.add(cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))));
            ArrayList<Order> orderList2 = new ArrayList<Order>();
            orderList2.add(cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))));
            orderList2.add(cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class))));
            cquery.orderBy(orderList1);
            cquery.orderBy(orderList2);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (TestUtil.traceflag) {
                for (Tuple actual : result) {
                    TestUtil.logTrace((String)("Actual - code=" + actual.get(0) + ", id=" + actual.get(1)));
                }
            }
            int i = 0;
            int passCount1 = 0;
            int passCount2 = 0;
            for (Tuple actual : result) {
                TestUtil.logTrace((String)("verifying: code=" + actual.get(0) + ", id=" + actual.get(1)));
                if (!actual.get(0).equals(((ExpectedResult)expected.get(i)).getArg1())) {
                    TestUtil.logErr((String)("Expected getArg1:" + ((ExpectedResult)expected.get(i)).getArg1() + ", actual.get(0):" + actual.get(0)));
                } else {
                    ++passCount1;
                }
                if (!actual.get(1).equals(((ExpectedResult)expected.get(i)).getArg2())) {
                    TestUtil.logErr((String)("Expected getArg2:" + ((ExpectedResult)expected.get(i)).getArg2() + ", actual.get(1):" + actual.get(1)));
                } else {
                    ++passCount2;
                }
                ++i;
            }
            if (passCount1 == expected.size()) {
                pass1 = true;
            }
            if (passCount2 == expected.size()) {
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("groupByListTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void having() throws EETest.Fault {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        int expectedRows = 2;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            cquery.groupBy(new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get("code")});
            Predicate exp = customer.get(Customer_2.getSingularAttribute("country", Country.class)).get("code").in(new Object[]{"GBR", "CHA"});
            cquery.having((Expression)exp).select((Selection)cbuilder.count((Expression)customer));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            int numOfExpected = 0;
            for (Long val : result) {
                if (!val.equals(expectedGBR) && !val.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected == 2) {
                TestUtil.logTrace((String)"Expected results received.");
                pass = true;
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size()));
                for (Long val : result) {
                    TestUtil.logErr((String)("Count of Codes Returned: " + val));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("having failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void distinct() throws EETest.Fault {
        ArrayList<String> expected;
        List actual;
        TypedQuery q;
        EmbeddableType Country_;
        Metamodel mm;
        EntityType Customer_2;
        Root customer;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        TestUtil.logMsg((String)"True test");
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            customer = cquery.from(Customer.class);
            Customer_2 = customer.getModel();
            mm = this.getEntityManagerFactory().getMetamodel();
            Country_ = mm.embeddable(Country.class);
            cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            cquery.distinct(true);
            q = this.getEntityManager().createQuery(cquery);
            actual = q.getResultList();
            Collections.sort(actual);
            expected = new ArrayList<String>();
            expected.add("CHA");
            expected.add("GBR");
            expected.add("IRE");
            expected.add("JPN");
            expected.add("USA");
            Collections.sort(expected);
            if (actual != null) {
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    pass1 = true;
                    if (TestUtil.traceflag) {
                        TestUtil.logTrace((String)("Received expected results(" + actual.size() + "):"));
                        for (String s : actual) {
                            TestUtil.logTrace((String)("code:" + s));
                        }
                    }
                } else {
                    TestUtil.logTrace((String)("Expected(" + expected.size() + "):"));
                    for (String s : expected) {
                        TestUtil.logTrace((String)("code:" + s));
                    }
                    TestUtil.logTrace((String)("Actual(" + actual.size() + "):"));
                    for (String s : actual) {
                        TestUtil.logTrace((String)("code:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"getResultList() returned null result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        TestUtil.logMsg((String)"False test");
        cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            customer = cquery.from(Customer.class);
            Customer_2 = customer.getModel();
            mm = this.getEntityManagerFactory().getMetamodel();
            Country_ = mm.embeddable(Country.class);
            cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            cquery.distinct(false);
            q = this.getEntityManager().createQuery(cquery);
            actual = q.getResultList();
            Collections.sort(actual);
            expected = new ArrayList();
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("GBR");
            expected.add("GBR");
            expected.add("IRE");
            expected.add("IRE");
            expected.add("JPN");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            Collections.sort(expected);
            if (actual != null) {
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    pass2 = true;
                    if (TestUtil.traceflag) {
                        TestUtil.logTrace((String)("Received expected results(" + actual.size() + "):"));
                        for (String s : expected) {
                            TestUtil.logTrace((String)("code:" + s));
                        }
                    }
                } else {
                    TestUtil.logTrace((String)("Expected(" + expected.size() + "):"));
                    for (String s : expected) {
                        TestUtil.logTrace((String)("code:" + s));
                    }
                    TestUtil.logTrace((String)("Actual(" + actual.size() + "):"));
                    for (String s : actual) {
                        TestUtil.logTrace((String)("code:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"getResultList() returned null result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        TestUtil.logMsg((String)"Default test");
        cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            customer = cquery.from(Customer.class);
            Customer_2 = customer.getModel();
            mm = this.getEntityManagerFactory().getMetamodel();
            Country_ = mm.embeddable(Country.class);
            cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            q = this.getEntityManager().createQuery(cquery);
            actual = q.getResultList();
            Collections.sort(actual);
            expected = new ArrayList();
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("GBR");
            expected.add("GBR");
            expected.add("IRE");
            expected.add("IRE");
            expected.add("JPN");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            Collections.sort(expected);
            if (actual != null) {
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    pass3 = true;
                    if (TestUtil.traceflag) {
                        TestUtil.logTrace((String)("Received expected results(" + actual.size() + "):"));
                        for (String s : expected) {
                            TestUtil.logTrace((String)("code:" + s));
                        }
                    }
                } else {
                    TestUtil.logTrace((String)("Expected(" + expected.size() + "):"));
                    for (String s : expected) {
                        TestUtil.logTrace((String)("code:" + s));
                    }
                    TestUtil.logTrace((String)("Actual(" + actual.size() + "):"));
                    for (String s : actual) {
                        TestUtil.logTrace((String)("code:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"getResultList() returned null result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("distinct test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void orderBy() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip"))).select((Selection)customer.get("work").get("zip"));
            Path exp1 = customer.get("work").get("zip");
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)exp1)});
            List lOrder = cquery.getOrderList();
            if (lOrder.size() == 1) {
                Order o = (Order)lOrder.get(0);
                if (!o.isAscending()) {
                    TestUtil.logErr((String)"isAscending() did not return an order of ascending");
                } else {
                    pass1 = true;
                }
                if (o.getExpression() != null) {
                    TestUtil.logTrace((String)"getExpression() returned non-null expression");
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)"getExpression() returned null");
                }
            } else {
                TestUtil.logErr((String)("Expected a size of 1, actual:" + lOrder.size()));
            }
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            TestUtil.logTrace((String)"Compare results of work zip codes");
            pass3 = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception queryTest47: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("orderBy failed");
        }
    }

    public void pathGetIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            customer.get("doesnotexist");
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("pathGetIllegalArgumentException failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void orderReverseTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"11345", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip")));
            cquery.select((Selection)customer.get("work").get("zip"));
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get("work").get("zip")).reverse()});
            List lOrder = cquery.getOrderList();
            if (lOrder.size() == 1) {
                Order o = (Order)lOrder.get(0);
                if (o.isAscending()) {
                    TestUtil.logErr((String)"isAscending() did not return an order of descending");
                } else {
                    pass1 = true;
                }
            } else {
                TestUtil.logErr((String)("Expected a size of 1, actual:" + lOrder.size()));
            }
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            TestUtil.logTrace((String)"Compare results of work zip codes");
            pass2 = Arrays.equals(expectedZips, result);
            if (!pass2) {
                TestUtil.logErr((String)"Results are incorrect:");
                for (Object s : expectedZips) {
                    TestUtil.logErr((String)("Expected:" + (String)s));
                }
                for (Object s : result) {
                    TestUtil.logErr((String)("actual:" + (String)s));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("orderReverseTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void getOrderList() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip"))).select((Selection)customer.get("work").get("zip")).orderBy(new Order[]{cbuilder.asc((Expression)customer.get("work").get("zip"))});
            List orderedList = cquery.getOrderList();
            if (orderedList != null) {
                if (orderedList.size() == 1) {
                    pass = true;
                    TestUtil.logTrace((String)"Received expected results");
                } else {
                    TestUtil.logErr((String)"Received Unexpected results");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception queryTest47: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getOrderList failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void getParameters() throws EETest.Fault {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            Set paramSet = cquery.getParameters();
            if (paramSet != null) {
                if (paramSet.isEmpty()) {
                    pass = true;
                    TestUtil.logTrace((String)"Received expected results");
                } else {
                    TestUtil.logErr((String)"Received Incorrect results");
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getParameters test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdateIllegalStateException1Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cb.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cb.equal((Expression)order.get("id"), (Object)"1"));
            this.getEntityManager().createQuery(cquery).executeUpdate();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("executeUpdateIllegalStateException1Test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void typeTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (HardwareProduct p : this.hardwareRef) {
            expected.add(Integer.valueOf(p.getId()));
        }
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.and(new Predicate[]{cbuilder.equal(product.type(), HardwareProduct.class)}));
            cquery.select((Selection)product);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception queryTest47: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("typeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void modifiedQueryTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(Integer.valueOf(this.customerRef[3].getId()));
        ArrayList<Integer> actual = new ArrayList<Integer>();
        TestUtil.logMsg((String)"Testing initial query");
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results for first query. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            TestUtil.logMsg((String)"Testing modified query");
            expected.clear();
            expected.add(Integer.valueOf(this.customerRef[7].getId()));
            actual.clear();
            cquery.select((Selection)customer.get("id"));
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Irene M. Caruso"));
            q = this.getEntityManager().createQuery(cquery);
            List lResult = q.getResultList();
            if (lResult.size() == 1) {
                Object o = lResult.get(0);
                actual.add(Integer.parseInt((String)o));
            } else {
                TestUtil.logErr((String)("Expected 1 result, actual:" + lResult.size()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results for second query. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("modifiedQueryTest test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void distinctNotSpecifiedTest() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"find All customer ids from Orders");
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
                EntityType Order_2 = order.getModel();
                Metamodel mm = this.getEntityManager().getMetamodel();
                EntityType Customer_2 = mm.entity(Customer.class);
                cquery.select((Selection)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("id", String.class)));
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List o = tq.getResultList();
                Integer[] expectedPKs = new Integer[]{Integer.parseInt("1"), Integer.parseInt("2"), Integer.parseInt("3"), Integer.parseInt("4"), Integer.parseInt("4"), Integer.parseInt("5"), Integer.parseInt("6"), Integer.parseInt("7"), Integer.parseInt("8"), Integer.parseInt("9"), Integer.parseInt("10"), Integer.parseInt("11"), Integer.parseInt("12"), Integer.parseInt("13"), Integer.parseInt("14"), Integer.parseInt("14"), Integer.parseInt("15"), Integer.parseInt("16"), Integer.parseInt("17"), Integer.parseInt("18")};
                if (!this.checkEntityPK(o, expectedPKs, true, true)) {
                    TestUtil.logErr((String)("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + o.size()));
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("distinctNotSpecifiedTest failed");
        }
    }

    @SetupMethod(name="setupAData")
    public void DoubleOperandResultTypeTests() throws EETest.Fault {
        Object p;
        double whereValue;
        ParameterExpression param;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1234.5;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1.0));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.gt((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1234.0;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.lt((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1235.0;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.notEqual((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1235.0;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1.0));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass7 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass8 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new EETest.Fault("DoubleOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    public void FloatOperandResultTypeTests() throws EETest.Fault {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)Float.valueOf(1.0f)));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected float type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)Float.valueOf(1.0f)));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected float type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected float type");
                pass7 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass8 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new EETest.Fault("FloatOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    public void BigDecimalOperandResultTypeTests() throws EETest.Fault {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)new BigDecimal(1)));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("BigDecimalOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    public void BigIntegerOperandResultTypeTests() throws EETest.Fault {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + BigInteger operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigInteger", BigInteger.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigInteger) {
                TestUtil.logTrace((String)"Received expected BigInteger type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigInteger:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - BigInteger operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigInteger", BigInteger.class)), (Number)new BigInteger("1")));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigInteger) {
                TestUtil.logTrace((String)"Received expected BigInteger type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigInteger:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * BigInteger operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigInteger", BigInteger.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigInteger) {
                TestUtil.logTrace((String)"Received expected BigInteger type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigInteger:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("BigIntegerOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    public void LongOperandResultTypeTests() throws EETest.Fault {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected Long type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigLong", Long.class)), (Number)1L));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected Long type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected Long type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected long type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicLong", Long.class)), (Number)1L));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected long type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected long type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new EETest.Fault("LongOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    public void ShortOperandResultTypeTests() throws EETest.Fault {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new EETest.Fault("ShortOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void resultContainsFetchReference() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Department.class);
        if (cquery != null) {
            Root d = cquery.from(Department.class);
            d.fetch((PluralAttribute)Department_.lastNameEmployees, JoinType.LEFT);
            cquery.where((Expression)cbuilder.equal((Expression)d.get(Department_.id), (Object)1)).select((Selection)d);
            cquery.distinct(true);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.deptRef[0].getId());
            if (result.size() == 1) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                actual.add(((Department)result.get(0)).getId());
                if (!this.checkEntityPK(actual, expected)) {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + result.size()));
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"More than 1 result got returned:");
                for (Department dept : result) {
                    TestUtil.logErr((String)("Dept:" + dept.toString()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("resultContainsFetchReference test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createATestData() {
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("9", null, 9, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private void removeATestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    public static class ExpectedResult {
        String arg1 = null;
        String arg2 = null;

        public ExpectedResult(String arg1) {
            this.arg1 = arg1;
        }

        public ExpectedResult(String arg1, String arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public String getArg1() {
            return this.arg1;
        }

        public void setArg1(String arg1) {
            this.arg1 = arg1;
        }

        public String getArg2() {
            return this.arg2;
        }

        public void setArg2(String arg2) {
            this.arg2 = arg2;
        }
    }
}

