/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.mappedsuperclasstype;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.mappedsuperclasstype.FullTimeEmployee;
import com.sun.ts.tests.jpa.core.metamodelapi.mappedsuperclasstype.FullTimeEmployee2;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void mappedSuperclassType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            pass = false;
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EntityType");
                for (EntityType mType : aSet) {
                    TestUtil.logTrace((String)("EntityType:" + mType.getJavaType().getName()));
                    IdentifiableType idType = mType.getSupertype();
                    if (idType == null) continue;
                    TestUtil.logTrace((String)("IdentifiableType:" + idType.getJavaType().getName()));
                    if (!(idType instanceof MappedSuperclassType)) continue;
                    TestUtil.logTrace((String)("type is instance of MappedSuperClassType:" + idType.getJavaType().getName()));
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("mappedSuperclassType failed");
        }
    }

    public void getDeclaredId() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getDeclaredId(String.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.String")) {
                            TestUtil.logTrace((String)("Received:" + name));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                        }
                    } else {
                        TestUtil.logErr((String)"getDeclaredId(...) returned null");
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredId failed");
        }
    }

    public void getDeclaredIdIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getDeclaredId(Date.class);
                        TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getDeclaredVersion(Integer.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.Integer")) {
                            TestUtil.logTrace((String)("Received:" + name));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected java.lang.Integer, actual:" + name));
                        }
                    } else {
                        TestUtil.logErr((String)"getDeclaredId(...) returned null");
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredVersion failed");
        }
    }

    public void getDeclaredVersionIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getDeclaredVersion(Date.class);
                        TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    public void getId() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getId(String.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.String")) {
                            TestUtil.logTrace((String)("Received:" + name));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                        }
                    } else {
                        TestUtil.logErr((String)"getDeclaredId(...) returned null");
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getId failed");
        }
    }

    public void getIdIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getId(Date.class);
                        TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdIllegalArgumentException failed");
        }
    }

    public void getIdClassAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    Set idAttribSet = idType.getIdClassAttributes();
                    if (idAttribSet != null) {
                        if (idAttribSet.size() > 0) {
                            for (Attribute attrib : idAttribSet) {
                                actual.add(attrib.getName());
                            }
                            Collections.sort(actual);
                            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                                TestUtil.logTrace((String)"Received expected attributes");
                                for (String attribName : expected) {
                                    TestUtil.logTrace((String)("attrib:" + attribName));
                                }
                                pass = true;
                            } else {
                                TestUtil.logErr((String)"Received Unexpected attributes");
                                TestUtil.logErr((String)"Expected:");
                                for (String attribName : expected) {
                                    TestUtil.logErr((String)("attrib:" + attribName));
                                }
                                TestUtil.logErr((String)"Actual:");
                                for (String attribName : actual) {
                                    TestUtil.logErr((String)("attrib:" + attribName));
                                }
                            }
                        } else {
                            TestUtil.logErr((String)"getIdClassAttributes() returned 0 results");
                        }
                    } else {
                        TestUtil.logErr((String)"getIdClassAttributes() returned null");
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdClassAttributes failed");
        }
    }

    public void getIdClassAttributesIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getIdClassAttributes();
                        TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    public void getIdType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    String name = idType.getIdType().getJavaType().getName();
                    if (name.equals("java.lang.String")) {
                        TestUtil.logTrace((String)("Received expected: " + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getId failed");
        }
    }

    public void getVersion() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = eType.getVersion(Integer.class);
                    String name = idAttrib.getType().getJavaType().getName();
                    if (name.equals("java.lang.Integer")) {
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected java.lang.Integer, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getVersion failed");
        }
    }

    public void getVersionIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        eType.getVersion(Date.class);
                        TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getVersionIllegalArgumentException failed");
        }
    }

    public void hasSingleIdAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    boolean hasSingleIdAttribute = idType.hasSingleIdAttribute();
                    if (hasSingleIdAttribute) {
                        pass = true;
                        TestUtil.logTrace((String)("hasSingleIdAttribute() returned" + hasSingleIdAttribute));
                    } else {
                        TestUtil.logErr((String)("Expected: false, actual:" + hasSingleIdAttribute));
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("hasSingleIdAttribute failed");
        }
    }

    public void hasVersionAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    boolean hasVersionAttribute = idType.hasVersionAttribute();
                    if (hasVersionAttribute) {
                        pass = true;
                        TestUtil.logTrace((String)("hasVersionAttribute() returned" + hasVersionAttribute));
                    } else {
                        TestUtil.logErr((String)("Expected: false, actual:" + hasVersionAttribute));
                    }
                } else {
                    TestUtil.logErr((String)"getSupertype() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("hasVersionAttribute failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

