/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.mapMsgTopic;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.util.ArrayList;
import java.util.Properties;

public class MapMsgTopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.mapMsgTopic.MapMsgTopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        MapMsgTopicTests theTests = new MapMsgTopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                TestUtil.logMsg((String)"Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"An error occurred while cleaning: ", (Throwable)e);
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void mapMessageFullMsgTopicTest() throws Exception {
        boolean pass = true;
        boolean booleanValue = false;
        byte byteValue = 127;
        byte[] bytesValue = new byte[]{127, -127, 1, 0};
        char charValue = 'Z';
        double doubleValue = 6.02E23;
        float floatValue = 6.02E23f;
        int intValue = Integer.MAX_VALUE;
        long longValue = Long.MAX_VALUE;
        short shortValue = Short.MAX_VALUE;
        String stringValue = "Map Message Test";
        Integer integerValue = 100;
        String initial = "spring is here!";
        try {
            byte[] b;
            MapMessage messageSentMapMessage = null;
            MapMessage messageReceivedMapMessage = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageFullMsgTopicTest");
            messageSentMapMessage.setBoolean("booleanValue", booleanValue);
            messageSentMapMessage.setByte("byteValue", byteValue);
            messageSentMapMessage.setBytes("bytesValue", bytesValue);
            messageSentMapMessage.setBytes("bytesValue2", bytesValue, 0, 1);
            messageSentMapMessage.setChar("charValue", charValue);
            messageSentMapMessage.setDouble("doubleValue", doubleValue);
            messageSentMapMessage.setFloat("floatValue", floatValue);
            messageSentMapMessage.setInt("intValue", intValue);
            messageSentMapMessage.setLong("longValue", longValue);
            messageSentMapMessage.setObject("integerValue", (Object)integerValue);
            messageSentMapMessage.setShort("shortValue", shortValue);
            messageSentMapMessage.setString("stringValue", stringValue);
            messageSentMapMessage.setString("nullTest", null);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                if (messageReceivedMapMessage.getBoolean("booleanValue") == booleanValue) {
                    TestUtil.logTrace((String)"Pass: valid boolean returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid boolean returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getByte("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: valid byte returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid byte returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                b = messageReceivedMapMessage.getBytes("bytesValue");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != bytesValue[i]) {
                        TestUtil.logMsg((String)("Fail: byte array " + i + " not valid"));
                        pass = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Pass: byte array " + i + " valid"));
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                b = messageReceivedMapMessage.getBytes("bytesValue2");
                if (b[0] != bytesValue[0]) {
                    TestUtil.logMsg((String)"Fail: byte array not valid");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: byte array valid");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getChar("charValue") == charValue) {
                    TestUtil.logTrace((String)"Pass: valid char returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid char returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getDouble("doubleValue") == doubleValue) {
                    TestUtil.logTrace((String)"Pass: valid double returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid double returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getFloat("floatValue") == floatValue) {
                    TestUtil.logTrace((String)"Pass: valid float returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid float returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getInt("intValue") == intValue) {
                    TestUtil.logTrace((String)"Pass: valid int returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid int returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getLong("longValue") == longValue) {
                    TestUtil.logTrace((String)"Pass: valid long returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid long returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getObject("integerValue").toString().equals(integerValue.toString())) {
                    TestUtil.logTrace((String)"Pass: valid object returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid object returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getShort("shortValue") == shortValue) {
                    TestUtil.logTrace((String)"Pass: valid short returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid short returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getString("stringValue").equals(stringValue)) {
                    TestUtil.logTrace((String)"Pass: valid string returned");
                } else {
                    TestUtil.logMsg((String)"Fail: invalid string returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getString("nullTest") == null) {
                    TestUtil.logTrace((String)"Pass: null returned");
                } else {
                    TestUtil.logMsg((String)"Fail:  null not returned from getString");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: mapMessageFullMsgTopicTest test failure");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("mapMessageFullMsgTopicTest");
        }
    }

    public void MapMessageConversionTopicTestsBoolean() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean booleanValue = true;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsBoolean");
            TestUtil.logTrace((String)"Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setBoolean("booleanValue", booleanValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readBoolean to read a boolean");
            try {
                if (messageReceived.getBoolean("booleanValue") == booleanValue) {
                    TestUtil.logTrace((String)"Pass: boolean to boolean - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readString to read a boolean");
            try {
                if (messageReceived.getString("booleanValue").equals(Boolean.valueOf(booleanValue).toString())) {
                    TestUtil.logTrace((String)"Pass: boolean to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                byte[] b = messageReceived.getBytes("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readByte to read a boolean - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readShort to read a boolean - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readChar to read a boolean - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readInt to read a boolean - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readLong to read a boolean - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readFloat to read a boolean - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use readDouble to read a boolean - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("booleanValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsBoolean", e);
        }
    }

    public void MapMessageConversionTopicTestsByte() throws Exception {
        MapMessage messageSent = null;
        MapMessage messageReceived = null;
        byte byteValue = 127;
        boolean pass = true;
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsByte");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setByte("byteValue", byteValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a byte - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("byteValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a byte");
            try {
                if (messageReceived.getString("byteValue").equals(Byte.toString(byteValue))) {
                    TestUtil.logTrace((String)"Pass: byte to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read a byte - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("byteValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a byte");
            try {
                if (messageReceived.getByte("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to byte - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a byte");
            try {
                if (messageReceived.getShort("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to short - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a boolean - this is not valid");
            try {
                char c = messageReceived.getChar("byteValue");
                pass = false;
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a byte");
            try {
                if (messageReceived.getInt("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to int - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a byte");
            try {
                if (messageReceived.getLong("byteValue") == (long)byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to long - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a boolean - this is not valid");
            try {
                float f = messageReceived.getFloat("byteValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a boolean - this is not valid");
            try {
                double d = messageReceived.getDouble("byteValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsByte", e);
        }
    }

    public void MapMessageConversionTopicTestsShort() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            short shortValue = 1;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsShort");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setShort("shortValue", shortValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a short - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("shortValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a short");
            try {
                if (messageReceived.getString("shortValue").equals(Short.toString(shortValue))) {
                    TestUtil.logTrace((String)"Pass: short to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read a short - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("shortValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a short - this is not valid");
            try {
                byte b = messageReceived.getByte("shortValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a short");
            try {
                if (messageReceived.getShort("shortValue") == shortValue) {
                    TestUtil.logTrace((String)"Pass: short to short - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a short - this is not valid");
            try {
                char c = messageReceived.getChar("shortValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a short");
            try {
                if (messageReceived.getInt("shortValue") == shortValue) {
                    TestUtil.logTrace((String)"Pass: short to int - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a short");
            try {
                if (messageReceived.getLong("shortValue") == (long)shortValue) {
                    TestUtil.logTrace((String)"Pass: short to long - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a short - this is not valid");
            try {
                float f = messageReceived.getFloat("shortValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a short - this is not valid");
            try {
                double d = messageReceived.getDouble("shortValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsShort", e);
        }
    }

    public void MapMessageConversionTopicTestsChar() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            char charValue = 'a';
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsChar");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setChar("charValue", charValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a char - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a char");
            try {
                if (messageReceived.getString("charValue").equals(Character.valueOf(charValue).toString())) {
                    TestUtil.logTrace((String)"Pass: char to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read a char - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a char - this is not valid");
            try {
                byte b = messageReceived.getByte("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a char");
            try {
                short s = messageReceived.getShort("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a char ");
            try {
                if (messageReceived.getChar("charValue") == charValue) {
                    TestUtil.logTrace((String)"Pass: char to char - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a char ");
            try {
                int i = messageReceived.getInt("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a char");
            try {
                long l = messageReceived.getLong("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a char - this is not valid");
            try {
                float f = messageReceived.getFloat("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a char - this is not valid");
            try {
                double d = messageReceived.getDouble("charValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsChar", e);
        }
    }

    public void MapMessageConversionTopicTestsInt() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            int intValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsInt");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setInt("intValue", intValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read an int - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read an int");
            try {
                if (messageReceived.getString("intValue").equals(Integer.toString(intValue))) {
                    TestUtil.logTrace((String)"Pass: int to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read an int - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read an int - this is not valid");
            try {
                byte b = messageReceived.getByte("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read an int");
            try {
                short s = messageReceived.getShort("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read an int - this is not valid");
            try {
                char c = messageReceived.getChar("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read an int");
            try {
                if (messageReceived.getInt("intValue") == intValue) {
                    TestUtil.logTrace((String)"Pass: int to int - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read an int");
            try {
                if (messageReceived.getLong("intValue") == (long)intValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read an int - this is not valid");
            try {
                float f = messageReceived.getFloat("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read an int - this is not valid");
            try {
                double d = messageReceived.getDouble("intValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsInt", e);
        }
    }

    public void MapMessageConversionTopicTestsLong() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            long longValue = 2L;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsLong");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setLong("longValue", longValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a long - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a long");
            try {
                if (messageReceived.getString("longValue").equals(Long.toString(longValue))) {
                    TestUtil.logTrace((String)"Pass: long to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read  a long - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read an long - this is not valid");
            try {
                byte b = messageReceived.getByte("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a long");
            try {
                short s = messageReceived.getShort("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a long - this is not valid");
            try {
                char c = messageReceived.getChar("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a long");
            try {
                int i = messageReceived.getInt("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a long");
            try {
                if (messageReceived.getLong("longValue") == longValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a long - this is not valid");
            try {
                float f = messageReceived.getFloat("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a long ");
            try {
                double d = messageReceived.getDouble("longValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsLong", e);
        }
    }

    public void MapMessageConversionTopicTestsFloat() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            float floatValue = 5.0f;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsFloat");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setFloat("floatValue", floatValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a float  ");
            try {
                boolean b = messageReceived.getBoolean("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a float");
            try {
                if (messageReceived.getString("floatValue").equals(Float.toString(floatValue))) {
                    TestUtil.logTrace((String)"Pass: float to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read  a float ");
            try {
                byte[] b = messageReceived.getBytes("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a float  ");
            try {
                byte b = messageReceived.getByte("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a float");
            try {
                short s = messageReceived.getShort("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a long  ");
            try {
                char c = messageReceived.getChar("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a float");
            try {
                int i = messageReceived.getInt("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a long");
            try {
                long l = messageReceived.getLong("floatValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a float  ");
            try {
                if (messageReceived.getFloat("floatValue") == floatValue) {
                    TestUtil.logTrace((String)"Pass: float to float - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a float  ");
            try {
                if (messageReceived.getDouble("floatValue") == (double)floatValue) {
                    TestUtil.logTrace((String)"Pass: float to double - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsFloat", e);
        }
    }

    public void MapMessageConversionTopicTestsDouble() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            double doubleValue = 3.0;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsDouble");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setDouble("doubleValue", doubleValue);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a double  ");
            try {
                boolean b = messageReceived.getBoolean("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a double");
            try {
                if (messageReceived.getString("doubleValue").equals(Double.toString(doubleValue))) {
                    TestUtil.logTrace((String)"Pass: double to string");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read  a double ");
            try {
                byte[] b = messageReceived.getBytes("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a double  ");
            try {
                byte b = messageReceived.getByte("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a double");
            try {
                short s = messageReceived.getShort("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a double  ");
            try {
                char c = messageReceived.getChar("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a double");
            try {
                int i = messageReceived.getInt("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a double");
            try {
                long l = messageReceived.getLong("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a double  ");
            try {
                float f = messageReceived.getFloat("doubleValue");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read an float  ");
            try {
                if (messageReceived.getDouble("doubleValue") == doubleValue) {
                    TestUtil.logTrace((String)"Pass: double to double ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsDouble", e);
        }
    }

    public void MapMessageConversionTopicTestsString() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean pass = true;
            String myString = "10";
            String myString2 = "true";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            messageSent.setString("myString2", myString2);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a String");
            try {
                if (messageReceived.getString("myString").equals(myString)) {
                    TestUtil.logTrace((String)"Pass: string to string - valid");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read a String");
            try {
                byte[] b = messageReceived.getBytes("myString");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a String");
            try {
                if (messageReceived.getByte("myString") == Byte.parseByte(myString)) {
                    TestUtil.logTrace((String)"Pass: String to byte ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a string");
            try {
                if (messageReceived.getShort("myString") == Short.parseShort(myString)) {
                    TestUtil.logTrace((String)"Pass: String to short ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a String ");
            try {
                char c = messageReceived.getChar("myString");
                TestUtil.logTrace((String)("getChar returned " + c));
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a String");
            try {
                if (messageReceived.getInt("myString") == Integer.parseInt(myString)) {
                    TestUtil.logTrace((String)"Pass: String to int ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a String");
            try {
                if (messageReceived.getLong("myString") == Long.parseLong(myString)) {
                    TestUtil.logTrace((String)"Pass: String to long ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a String");
            try {
                if (messageReceived.getFloat("myString") == Float.parseFloat(myString)) {
                    TestUtil.logTrace((String)"Pass: String to float ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a String");
            try {
                if (messageReceived.getDouble("myString") == Double.parseDouble(myString)) {
                    TestUtil.logTrace((String)"Pass: String to double ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a string ");
            try {
                if (messageReceived.getBoolean("myString2") == Boolean.valueOf(myString2).booleanValue()) {
                    TestUtil.logTrace((String)"Pass: String to boolean ");
                } else {
                    TestUtil.logMsg((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a string that is not true");
            try {
                boolean b = messageReceived.getBoolean("myString");
                if (b) {
                    TestUtil.logMsg((String)"Fail: !true should have returned false");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsString", e);
        }
    }

    public void MapMessageConversionTopicTestsBytes() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            byte[] byteValues = new byte[]{1, 2, 3};
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsBytes");
            TestUtil.logTrace((String)"Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setBytes("byteValues", byteValues);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBytes[] to read a byte[] ");
            try {
                byte[] b = messageReceived.getBytes("byteValues");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != byteValues[i]) {
                        TestUtil.logMsg((String)"Fail: byte[] value returned is invalid");
                        pass = false;
                        continue;
                    }
                    TestUtil.logTrace((String)"Pass: byte[] returned is valid");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getBoolean to read a byte[]");
            try {
                boolean b = messageReceived.getBoolean("byteValues");
                TestUtil.logMsg((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getString to read a byte[]");
            try {
                String s = messageReceived.getString("byteValues");
                TestUtil.logMsg((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a byte[] - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a byte[] - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getChar to read a byte[] - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a byte[] - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a byte[] - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a byte[] - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a byte[] - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("byteValues");
                TestUtil.logMsg((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsBytes", e);
        }
    }

    public void MapMessageConversionTopicTestsInvFormatString() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean pass = true;
            String myString = "mytest string";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionTopicTestsInvFormatString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getByte to read a String that is not valid ");
            try {
                byte b = messageReceived.getByte("myString");
                TestUtil.logMsg((String)"Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getShort to read a string that is not valid ");
            try {
                short s = messageReceived.getShort("myString");
                TestUtil.logMsg((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getInt to read a String that is not valid ");
            try {
                int i = messageReceived.getInt("myString");
                TestUtil.logMsg((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getLong to read a String that is not valid ");
            try {
                long l = messageReceived.getLong("myString");
                TestUtil.logMsg((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getFloat to read a String that is not valid ");
            try {
                float f = messageReceived.getFloat("myString");
                TestUtil.logMsg((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"--");
            TestUtil.logMsg((String)"Use getDouble to read a String that is not valid ");
            try {
                double d = messageReceived.getDouble("myString");
                TestUtil.logMsg((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("MapMessageConversionTopicTestsInvFormatString", e);
        }
    }

    public void mapMessageTNotWritable() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            char cValue = '\uffff';
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            byte[] bbValue = new byte[]{0, 88, 127};
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageTNotWritable");
            try {
                messageSent.setString("ssValue", ssValue);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Error: unexpected exception was thrown: ", (Throwable)e);
                throw new Exception("Error: failed to setString", e);
            }
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            TestUtil.logMsg((String)"Writing a boolean ... ");
            try {
                messageReceived.setBoolean("pass", pass);
                TestUtil.logErr((String)"Shouldn't get here");
                throw new Exception("Error: test failed to be able to setBoolean");
            }
            catch (MessageNotWriteableException e) {
                TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setBoolean");
                TestUtil.logMsg((String)"Writing a byte ... ");
                try {
                    messageReceived.setByte("bValue", bValue);
                    TestUtil.logErr((String)"Shouldn't get here");
                    throw new Exception("Error: test failed to be able to setByte");
                }
                catch (MessageNotWriteableException e2) {
                    TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setByte");
                    TestUtil.logMsg((String)"Writing a short ... ");
                    try {
                        messageReceived.setShort("sValue", sValue);
                        TestUtil.logErr((String)"Shouldn't get here");
                        throw new Exception("Error: test failed to be able to setShort");
                    }
                    catch (MessageNotWriteableException e3) {
                        TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setShort");
                        TestUtil.logMsg((String)"Writing a char ... ");
                        try {
                            messageReceived.setChar("cValue", cValue);
                            TestUtil.logErr((String)"Shouldn't get here");
                            throw new Exception("Error: test failed to be able to setChar");
                        }
                        catch (MessageNotWriteableException e4) {
                            TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setChar");
                            TestUtil.logMsg((String)"Writing a int ... ");
                            try {
                                messageReceived.setInt("iValue", iValue);
                                TestUtil.logErr((String)"Shouldn't get here");
                                throw new Exception("Error: test failed to be able to setInt");
                            }
                            catch (MessageNotWriteableException e5) {
                                TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setInt");
                                TestUtil.logMsg((String)"Writing a long ... ");
                                try {
                                    messageReceived.setLong("lValue", lValue);
                                    TestUtil.logErr((String)"Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to setLong");
                                }
                                catch (MessageNotWriteableException e6) {
                                    TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setLong");
                                    TestUtil.logMsg((String)"Writing a float ... ");
                                    try {
                                        messageReceived.setFloat("fValue", fValue);
                                        TestUtil.logErr((String)"Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to setFloat");
                                    }
                                    catch (MessageNotWriteableException e7) {
                                        TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setFloat");
                                        TestUtil.logMsg((String)"Writing a double ... ");
                                        try {
                                            messageReceived.setDouble("dValue", dValue);
                                            TestUtil.logErr((String)"Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to setDouble");
                                        }
                                        catch (MessageNotWriteableException e8) {
                                            TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setDouble");
                                            TestUtil.logMsg((String)"Writing a bytes... ");
                                            try {
                                                messageReceived.setBytes("bbValue", bbValue);
                                                TestUtil.logErr((String)"Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to setBytes");
                                            }
                                            catch (MessageNotWriteableException e9) {
                                                TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setBytes");
                                                TestUtil.logMsg((String)"Writing a bytes... ");
                                                try {
                                                    messageReceived.setBytes("bbValue", bbValue, 0, 1);
                                                    TestUtil.logErr((String)"Shouldn't get here");
                                                    throw new Exception("Error: test failed to be able to setBytes");
                                                }
                                                catch (MessageNotWriteableException e10) {
                                                    TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setBytes");
                                                    TestUtil.logMsg((String)"Writing a string ... ");
                                                    try {
                                                        messageReceived.setString("ssValue", ssValue);
                                                        TestUtil.logErr((String)"Shouldn't get here");
                                                        throw new Exception("Error: test failed to be able to setString");
                                                    }
                                                    catch (MessageNotWriteableException e11) {
                                                        TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setString");
                                                        TestUtil.logMsg((String)"Writing a object ... ");
                                                        try {
                                                            messageReceived.setObject("oValue", (Object)new Integer(iValue));
                                                            TestUtil.logErr((String)"Shouldn't get here");
                                                            throw new Exception("Error: test failed to be able to setObject");
                                                        }
                                                        catch (MessageNotWriteableException e12) {
                                                            TestUtil.logMsg((String)"Got Expected MessageNotWriteableException with setObject");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("mapMessageTNotWriteable", e);
        }
    }

    public void mapMessageTIllegalarg() throws Exception {
        try {
            MapMessage messageSent = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            char cValue = '\uffff';
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            byte[] bbValue = new byte[]{0, 88, 127};
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageTIllegalarg");
            TestUtil.logMsg((String)"Writing a boolean ... ");
            try {
                messageSent.setBoolean("", pass);
                TestUtil.logErr((String)"Shouldn't get here");
                throw new Exception("Error: test failed to be able to setBoolean");
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setBoolean");
                TestUtil.logMsg((String)"Writing a byte ... ");
                try {
                    messageSent.setByte("", bValue);
                    TestUtil.logErr((String)"Shouldn't get here");
                    throw new Exception("Error: test failed to be able to setByte");
                }
                catch (IllegalArgumentException e2) {
                    TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setByte");
                    TestUtil.logMsg((String)"Writing a short ... ");
                    try {
                        messageSent.setShort("", sValue);
                        TestUtil.logErr((String)"Shouldn't get here");
                        throw new Exception("Error: test failed to be able to setShort");
                    }
                    catch (IllegalArgumentException e3) {
                        TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setShort");
                        TestUtil.logMsg((String)"Writing a char ... ");
                        try {
                            messageSent.setChar("", cValue);
                            TestUtil.logErr((String)"Shouldn't get here");
                            throw new Exception("Error: test failed to be able to setChar");
                        }
                        catch (IllegalArgumentException e4) {
                            TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setChar");
                            TestUtil.logMsg((String)"Writing a int ... ");
                            try {
                                messageSent.setInt("", iValue);
                                TestUtil.logErr((String)"Shouldn't get here");
                                throw new Exception("Error: test failed to be able to setInt");
                            }
                            catch (IllegalArgumentException e5) {
                                TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setInt");
                                TestUtil.logMsg((String)"Writing a long ... ");
                                try {
                                    messageSent.setLong("", lValue);
                                    TestUtil.logErr((String)"Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to setLong");
                                }
                                catch (IllegalArgumentException e6) {
                                    TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setLong");
                                    TestUtil.logMsg((String)"Writing a float ... ");
                                    try {
                                        messageSent.setFloat("", fValue);
                                        TestUtil.logErr((String)"Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to setFloat");
                                    }
                                    catch (IllegalArgumentException e7) {
                                        TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setFloat");
                                        TestUtil.logMsg((String)"Writing a double ... ");
                                        try {
                                            messageSent.setDouble("", dValue);
                                            TestUtil.logErr((String)"Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to setDouble");
                                        }
                                        catch (IllegalArgumentException e8) {
                                            TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setDouble");
                                            TestUtil.logMsg((String)"Writing a bytes... ");
                                            try {
                                                messageSent.setBytes("", bbValue);
                                                TestUtil.logErr((String)"Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to setBytes");
                                            }
                                            catch (IllegalArgumentException e9) {
                                                TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setBytes");
                                                TestUtil.logMsg((String)"Writing a bytes... ");
                                                try {
                                                    messageSent.setBytes("", bbValue, 0, 1);
                                                    TestUtil.logErr((String)"Shouldn't get here");
                                                    throw new Exception("Error: test failed to be able to setBytes");
                                                }
                                                catch (IllegalArgumentException e10) {
                                                    TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setBytes");
                                                    TestUtil.logMsg((String)"Writing a string ... ");
                                                    try {
                                                        messageSent.setString("", ssValue);
                                                        TestUtil.logErr((String)"Shouldn't get here");
                                                        throw new Exception("Error: test failed to be able to setString");
                                                    }
                                                    catch (IllegalArgumentException e11) {
                                                        TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setString");
                                                        TestUtil.logMsg((String)"Writing a object ... ");
                                                        try {
                                                            messageSent.setObject("", (Object)new Integer(iValue));
                                                            TestUtil.logErr((String)"Shouldn't get here");
                                                            throw new Exception("Error: test failed to be able to setObject");
                                                        }
                                                        catch (IllegalArgumentException e12) {
                                                            TestUtil.logMsg((String)"Got Expected IllegalArgumentException with setObject");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("mapMessageTIllegalarg", e);
        }
    }
}

