/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt13;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient13
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt13";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private csSchema csSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private CallableStatement cstmt = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        callStmtClient13 theTests = new callStmtClient13();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject101() throws Exception {
        Boolean oMaxNumericVal = null;
        BigDecimal rNumericVal = null;
        String smaxNumericVal = null;
        BigDecimal maxNumericVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Numeric Table");
            smaxNumericVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            maxNumericVal = new BigDecimal(smaxNumericVal);
            oMaxNumericVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMaxNumericVal, 2, 2);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxNumericVal, "" + rNumericVal);
            if (rNumericVal.compareTo(maxNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject102() throws Exception {
        Boolean oMinNumericVal = null;
        BigDecimal rNumericVal = null;
        String sminNumericVal = null;
        BigDecimal minNumericVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_In_Max(?)}");
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Numeric Table");
            sminNumericVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            minNumericVal = new BigDecimal(sminNumericVal);
            oMinNumericVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMinNumericVal, 2, 2);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Max", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minNumericVal, "" + rNumericVal);
            if (rNumericVal.compareTo(minNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject105() throws Exception {
        Boolean oMaxBooleanVal = null;
        String smaxBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Char Table");
            smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMaxBooleanVal, 1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject106() throws Exception {
        Boolean oMinBooleanVal = null;
        String sminBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Char Table");
            sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMinBooleanVal, 1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject107() throws Exception {
        Boolean oMaxBooleanVal = null;
        String smaxBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Varchar Table");
            smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMaxBooleanVal, 12);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject108() throws Exception {
        Boolean oMinBooleanVal = null;
        String sminBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Varchar Table");
            sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMinBooleanVal, 12);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject109() throws Exception {
        Boolean oMaxBooleanVal = null;
        String smaxBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.msg.setMsg("extract the Maximum Value of Boolean to be Updated in Longvarchar Table");
            smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMaxBooleanVal, -1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject110() throws Exception {
        Boolean oMinBooleanVal = null;
        String sminBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Boolean to be Updated in Longvarchar Table");
            sminBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 2, this.sqlp, this.conn);
            oMinBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.cstmt.setObject(1, (Object)oMinBooleanVal, -1);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject111() throws Exception {
        Integer maxIntegerVal = null;
        Integer rTinyintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Tinyint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, -6);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Tinyint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object oTinyintVal = this.rs.getObject(1);
            rTinyintVal = new Integer(oTinyintVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rTinyintVal);
            if (rTinyintVal.compareTo(maxIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject112() throws Exception {
        Integer minIntegerVal = null;
        Integer rTinyintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Tinyint to be Updated");
            sminStringVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, -6);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oTinyintVal = this.rs.getObject(1);
            rTinyintVal = new Integer(oTinyintVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rTinyintVal);
            if (rTinyintVal.compareTo(minIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject113() throws Exception {
        Integer maxIntegerVal = null;
        Integer rSmallintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Smallint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 5);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object oSmallintVal = this.rs.getObject(1);
            rSmallintVal = new Integer(oSmallintVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rSmallintVal);
            if (rSmallintVal.compareTo(maxIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject114() throws Exception {
        Integer minIntegerVal = null;
        Integer rSmallintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Smallint to be Updated");
            sminStringVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 5);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oSmallintVal = this.rs.getObject(1);
            rSmallintVal = new Integer(oSmallintVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rSmallintVal);
            if (rSmallintVal.compareTo(minIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject115() throws Exception {
        Integer maxIntegerVal = null;
        Integer rIntegerVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Integer to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 4);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Integer_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object oIntegerVal = this.rs.getObject(1);
            rIntegerVal = new Integer(oIntegerVal.toString());
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.compareTo(maxIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject116() throws Exception {
        Integer minIntegerVal = null;
        Integer rIntegerVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Integer to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 4);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oIntegerVal = this.rs.getObject(1);
            rIntegerVal = new Integer(oIntegerVal.toString());
            this.msg.addOutputMsg("" + minIntegerVal, "" + rIntegerVal);
            if (rIntegerVal.compareTo(minIntegerVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject117() throws Exception {
        Long maxBigintVal = null;
        Integer maxIntegerVal = null;
        Long rBigintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Bigint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxBigintVal = new Long(smaxStringVal);
            maxIntegerVal = new Integer(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, -5);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Bigint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object oBigintVal = this.rs.getObject(1);
            rBigintVal = new Long(oBigintVal.toString());
            this.msg.addOutputMsg("" + maxBigintVal, "" + rBigintVal);
            if (rBigintVal.compareTo(maxBigintVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject118() throws Exception {
        Long minBigintVal = null;
        Integer minIntegerVal = null;
        Long rBigintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Bigint to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            minBigintVal = new Long(sminStringVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, -5);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oBigintVal = this.rs.getObject(1);
            rBigintVal = new Long(oBigintVal.toString());
            this.msg.addOutputMsg("" + minBigintVal, "" + rBigintVal);
            if (rBigintVal.compareTo(minBigintVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject119() throws Exception {
        Float maxRealVal = null;
        Integer maxIntegerVal = null;
        Float rRealVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_In_Min(?)}");
            this.msg.setMsg("extract the Maximum Value of Float to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = new Integer(smaxStringVal);
            maxRealVal = new Float(smaxStringVal);
            this.cstmt.setObject(1, (Object)maxIntegerVal, 7);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Real_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object oRealVal = this.rs.getObject(1);
            rRealVal = new Float(oRealVal.toString());
            this.msg.addOutputMsg("" + maxRealVal, "" + rRealVal);
            if (rRealVal.compareTo(maxRealVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject120() throws Exception {
        Float minRealVal = null;
        Integer minIntegerVal = null;
        Float rRealVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_In_Null(?)}");
            this.msg.setMsg("extract the Minimum Value of Float to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = new Integer(sminStringVal);
            minRealVal = new Float(sminStringVal);
            this.msg.setMsg("Minimum Real Value :" + minRealVal);
            this.cstmt.setObject(1, (Object)minIntegerVal, 7);
            this.cstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of cstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Real_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object oRealVal = this.rs.getObject(1);
            rRealVal = new Float(oRealVal.toString());
            this.msg.addOutputMsg("" + minRealVal, "" + rRealVal);
            if (rRealVal.compareTo(minRealVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

