/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.entitytype;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.entitytype.A;
import ee.jakarta.tck.persistence.core.metamodelapi.entitytype.DID2Employee;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getName() throws Exception {
        boolean pass = false;
        String expected = "A";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String name = eType.getName();
                if (name.equals(expected)) {
                    this.logTrace("Received:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected: " + expected + ", actual:" + name);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName failed");
        }
    }

    public void getDeclaredId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                this.logTrace("entityType Name = A");
                SingularAttribute idAttrib = eType.getDeclaredId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    this.logTrace("Received:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected java.lang.String, actual:" + name);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredId failed");
        }
    }

    public void getDeclaredIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("Obtained A IdentifiableType");
                try {
                    eType.getDeclaredId(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                SingularAttribute idAttrib = eType.getDeclaredVersion(Integer.class);
                String name = idAttrib.getName();
                if (name.equals("value")) {
                    this.logTrace("Received:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected: value, actual:" + name);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersion failed");
        }
    }

    public void getDeclaredVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                try {
                    eType.getDeclaredVersion(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    public void getId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                SingularAttribute idAttrib = eType.getId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    this.logTrace("Received expected: " + name);
                    pass = true;
                } else {
                    this.logErr("Expected java.lang.String, actual:" + name);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    public void getIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("Obtained A Entity");
                try {
                    eType.getId(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdIllegalArgumentException failed");
        }
    }

    public void getIdClassAttributes() throws Exception {
        boolean pass = false;
        HashSet<String> expected = new HashSet<String>();
        expected.add("firstName");
        expected.add("lastName");
        HashSet<String> actual = new HashSet<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(DID2Employee.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                Set idClassAttribSet = eType.getIdClassAttributes();
                if (idClassAttribSet != null) {
                    if (idClassAttribSet.size() > 0) {
                        for (SingularAttribute attrib : idClassAttribSet) {
                            actual.add(attrib.getName());
                        }
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            this.logTrace("Received expected attributes");
                            for (String id : expected) {
                                this.logTrace("id:" + id);
                            }
                            pass = true;
                        } else {
                            this.logErr("Received Unexpected ids");
                            this.logErr("Expected:");
                            for (String id : expected) {
                                this.logErr("id:" + id);
                            }
                            this.logErr("Actual:");
                            for (String attribName : actual) {
                                this.logErr("attrib:" + attribName);
                            }
                        }
                    } else {
                        this.logErr("getIdClassAttributes() returned 0 items");
                    }
                } else {
                    this.logErr("getIdClassAttributes() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributes failed");
        }
    }

    public void getIdClassAttributesIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained A Entity");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                try {
                    eType.getIdClassAttributes();
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    public void getIdType() throws Exception {
        boolean pass = false;
        String expected = "java.lang.String";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                Type type = eType.getIdType();
                String sType = type.getJavaType().getName();
                if (sType.equals(expected)) {
                    this.logTrace("Received:" + sType);
                    pass = true;
                } else {
                    this.logErr("Expected: " + expected + ", actual:" + sType);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdType failed");
        }
    }

    public void getSupertype() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.entitytype.B";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                IdentifiableType idType = eType.getSupertype();
                String name = idType.getJavaType().getName();
                if (name.equals(expected)) {
                    this.logTrace("getSuperType() returned:" + name);
                    pass = true;
                } else {
                    this.logErr("Expected: " + expected + ", actual:" + name);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSupertype failed");
        }
    }

    public void getVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                SingularAttribute idAttrib = eType.getVersion(Integer.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.Integer")) {
                    pass = true;
                } else {
                    this.logErr("Expected java.lang.Integer, actual:" + name);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersion failed");
        }
    }

    public void getVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("Obtained A Entity");
                try {
                    eType.getVersion(Date.class);
                    this.logTrace("Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersionIllegalArgumentException failed");
        }
    }

    public void hasSingleIdAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("entityType Name = " + eType.getName());
                boolean hasSingleIdAttribute = eType.hasSingleIdAttribute();
                if (hasSingleIdAttribute) {
                    pass = true;
                    this.logTrace("hasSingleIdAttribute() returned" + hasSingleIdAttribute);
                } else {
                    this.logErr("Expected: false, actual:" + hasSingleIdAttribute);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasSingleIdAttribute failed");
        }
    }

    public void hasVersionAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                this.logTrace("entityType Name = " + eType.getName());
                boolean hasVersionAttribute = eType.hasVersionAttribute();
                if (hasVersionAttribute) {
                    pass = true;
                    this.logTrace("hasSingleIdAttribute() returned" + hasVersionAttribute);
                } else {
                    this.logErr("Expected: false, actual:" + hasVersionAttribute);
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasVersionAttribute failed");
        }
    }

    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.entitytype.A";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String bindableJavaType = eType.getBindableJavaType().getName();
                if (bindableJavaType != null) {
                    if (bindableJavaType.equals(expected)) {
                        this.logTrace("Received expected result: " + bindableJavaType);
                        pass = true;
                    } else {
                        this.logTrace("Expected:" + expected + ", actual:" + bindableJavaType);
                    }
                } else {
                    this.logErr("getName() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType failed");
        }
    }

    public void getBindableType() throws Exception {
        boolean pass = false;
        String expected = Bindable.BindableType.ENTITY_TYPE.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String bindableType = eType.getBindableType().name();
                if (bindableType != null) {
                    if (bindableType.equals(expected)) {
                        this.logTrace("Received expected result: " + bindableType);
                        pass = true;
                    } else {
                        this.logTrace("Expected:" + expected + ", actual:" + bindableType);
                    }
                } else {
                    this.logErr("getBindableType() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

