/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.index.Index;

public class EntryResult {
    private final char[] word;
    private Object[] documentTables;
    private SimpleSet documentNames;

    public EntryResult(char[] word, Object table) {
        this.word = word;
        if (table != null) {
            this.documentTables = new Object[]{table};
        }
    }

    public void addDocumentName(String documentName) {
        if (this.documentNames == null) {
            this.documentNames = new SimpleSet(3);
        }
        this.documentNames.add((Object)documentName);
    }

    public void addDocumentTable(Object table) {
        if (this.documentTables != null) {
            int length = this.documentTables.length;
            this.documentTables = new Object[length + 1];
            System.arraycopy(this.documentTables, 0, this.documentTables, 0, length);
            this.documentTables[length] = table;
        } else {
            this.documentTables = new Object[]{table};
        }
    }

    public char[] getWord() {
        return this.word;
    }

    public String[] getDocumentNames(Index index) throws IOException {
        Object[] values;
        int n;
        if (this.documentTables != null) {
            int length = this.documentTables.length;
            if (length == 1 && this.documentNames == null) {
                Object offset = this.documentTables[0];
                int[] numbers = index.diskIndex.readDocumentNumbers(offset);
                String[] names = new String[numbers.length];
                int i = 0;
                int l = numbers.length;
                while (i < l) {
                    names[i] = index.diskIndex.readDocumentName(numbers[i]);
                    ++i;
                }
                return names;
            }
            int i = 0;
            while (i < length) {
                int[] numbers;
                Object offset = this.documentTables[i];
                int[] nArray = numbers = index.diskIndex.readDocumentNumbers(offset);
                int n2 = numbers.length;
                n = 0;
                while (n < n2) {
                    int number = nArray[n];
                    this.addDocumentName(index.diskIndex.readDocumentName(number));
                    ++n;
                }
                ++i;
            }
        }
        if (this.documentNames == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] names = new String[this.documentNames.elementSize];
        int count = 0;
        Object[] objectArray = values = this.documentNames.values;
        n = values.length;
        int n3 = 0;
        while (n3 < n) {
            Object value = objectArray[n3];
            if (value != null) {
                names[count++] = (String)value;
            }
            ++n3;
        }
        return names;
    }

    public boolean isEmpty() {
        return this.documentTables == null && this.documentNames == null;
    }
}

