/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.unix.PreferredDirectByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;

class EpollRecvByteAllocatorHandle
implements RecvByteBufAllocator.ExtendedHandle {
    private final PreferredDirectByteBufAllocator preferredDirectByteBufAllocator = new PreferredDirectByteBufAllocator();
    private final RecvByteBufAllocator.ExtendedHandle delegate;
    private final UncheckedBooleanSupplier defaultMaybeMoreDataSupplier = new UncheckedBooleanSupplier(){

        public boolean get() {
            return EpollRecvByteAllocatorHandle.this.maybeMoreDataToRead();
        }
    };
    private boolean isEdgeTriggered;
    private boolean receivedRdHup;

    EpollRecvByteAllocatorHandle(RecvByteBufAllocator.ExtendedHandle handle) {
        this.delegate = (RecvByteBufAllocator.ExtendedHandle)ObjectUtil.checkNotNull((Object)handle, (String)"handle");
    }

    final void receivedRdHup() {
        this.receivedRdHup = true;
    }

    final boolean isReceivedRdHup() {
        return this.receivedRdHup;
    }

    boolean maybeMoreDataToRead() {
        return this.isEdgeTriggered && this.lastBytesRead() > 0 || !this.isEdgeTriggered && this.lastBytesRead() == this.attemptedBytesRead();
    }

    final void edgeTriggered(boolean edgeTriggered) {
        this.isEdgeTriggered = edgeTriggered;
    }

    final boolean isEdgeTriggered() {
        return this.isEdgeTriggered;
    }

    public final ByteBuf allocate(ByteBufAllocator alloc) {
        this.preferredDirectByteBufAllocator.updateAllocator(alloc);
        return this.delegate.allocate((ByteBufAllocator)this.preferredDirectByteBufAllocator);
    }

    public final int guess() {
        return this.delegate.guess();
    }

    public final void reset(ChannelConfig config) {
        this.delegate.reset(config);
    }

    public final void incMessagesRead(int numMessages) {
        this.delegate.incMessagesRead(numMessages);
    }

    public final void lastBytesRead(int bytes) {
        this.delegate.lastBytesRead(bytes);
    }

    public final int lastBytesRead() {
        return this.delegate.lastBytesRead();
    }

    public final int attemptedBytesRead() {
        return this.delegate.attemptedBytesRead();
    }

    public final void attemptedBytesRead(int bytes) {
        this.delegate.attemptedBytesRead(bytes);
    }

    public final void readComplete() {
        this.delegate.readComplete();
    }

    public final boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
        return this.delegate.continueReading(maybeMoreDataSupplier);
    }

    public final boolean continueReading() {
        return this.delegate.continueReading(this.defaultMaybeMoreDataSupplier);
    }
}

