/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;

public class AMQPConnectionDetails {
    public static final String AMQP_HOST = "AMQP_SERVICE_HOST";
    public static final String AMQP_PORT = "AMQP_SERVICE_PORT";
    public static final String AMQP_USERNAME = "AMQP_SERVICE_USERNAME";
    public static final String AMQP_PASSWORD = "AMQP_SERVICE_PASSWORD";
    private final String uri;
    private final String username;
    private final String password;

    public AMQPConnectionDetails(String uri, String username, String password) {
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public AMQPConnectionDetails(String uri) {
        this(uri, null, null);
    }

    public static AMQPConnectionDetails discoverAMQP(CamelContext camelContext) {
        try {
            PropertiesComponent propertiesComponent = (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
            String host = AMQPConnectionDetails.property(propertiesComponent, AMQP_HOST, "localhost");
            int port = Integer.parseInt(AMQPConnectionDetails.property(propertiesComponent, AMQP_PORT, "5672"));
            String username = AMQPConnectionDetails.property(propertiesComponent, AMQP_USERNAME, null);
            String password = AMQPConnectionDetails.property(propertiesComponent, AMQP_PASSWORD, null);
            return new AMQPConnectionDetails("amqp://" + host + ":" + port, username, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String uri() {
        return this.uri;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    private static String property(PropertiesComponent propertiesComponent, String key, String defaultValue) {
        try {
            return propertiesComponent.parseUri(propertiesComponent.getPrefixToken() + key + propertiesComponent.getSuffixToken());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

