/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.storage.cm;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.internal.ip.ProvisioningStorage;
import org.eclipse.equinox.internal.ip.impl.Log;
import org.eclipse.equinox.internal.ip.impl.ProvisioningAgent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.provisioning.ProvisioningService;
import org.osgi.util.tracker.ServiceTracker;

public class CMStorage
implements ProvisioningStorage,
ManagedService,
BundleActivator {
    public static final String PID = "equinox.provisioning.provisioning.pid";
    public static final String CM_SUPPORT = "equinox.provisioning.cm.support";
    private ServiceRegistration msSReg;
    private ServiceRegistration sSReg;
    private ServiceTracker prvSrvTracker;
    private ServiceTracker cmTracker;
    private BundleContext bc;
    private int counter;
    private boolean infoLoaded;
    private boolean skipStore;
    private boolean registering;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void start(BundleContext bc) throws Exception {
        Log.debug = ProvisioningAgent.getBoolean("equinox.provisioning.debug");
        boolean cmsupport = true;
        if (ProvisioningAgent.bc.getProperty(CM_SUPPORT) != null && ProvisioningAgent.bc.getProperty(CM_SUPPORT).equals("false")) {
            cmsupport = false;
        }
        if (!cmsupport) {
            Log.debug(this + " is not supported provider/storage!");
            return;
        }
        this.bc = bc;
        this.counter = 0;
        this.registering = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.provisioning.ProvisioningService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.prvSrvTracker = new ServiceTracker(bc, clazz.getName(), null);
        this.prvSrvTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cmTracker = new ServiceTracker(bc, clazz2.getName(), null);
        this.cmTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>(1, 1.0f);
        ((Dictionary)props).put("service.pid", PID);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.msSReg = bc.registerService(clazz3.getName(), (Object)this, props);
        Log.debug("Managed Service Registered.");
    }

    public void stop(BundleContext bc) {
        Log.debug("Close " + this + '.');
        bc = null;
        try {
            if (this.sSReg != null) {
                this.sSReg.unregister();
                this.sSReg = null;
            }
        }
        catch (Exception exception) {}
        try {
            if (this.msSReg != null) {
                this.msSReg.unregister();
                this.msSReg = null;
            }
        }
        catch (Exception exception) {}
        this.prvSrvTracker.close();
        this.prvSrvTracker = null;
        this.cmTracker.close();
        this.cmTracker = null;
    }

    public Dictionary getStoredInfo() {
        ConfigurationAdmin cm;
        block3: {
            try {
                cm = (ConfigurationAdmin)this.cmTracker.getService();
                if (cm != null) break block3;
                return null;
            }
            catch (IOException ioe) {
                Log.debug(ioe);
                return null;
            }
        }
        Configuration config = cm.getConfiguration(PID);
        Dictionary info = config.getProperties();
        this.infoLoaded = true;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Dictionary provisioningData) {
        try {
            CMStorage cMStorage = this;
            synchronized (cMStorage) {
                if (this.skipStore) {
                    this.skipStore = false;
                    return;
                }
            }
            ConfigurationAdmin cm = (ConfigurationAdmin)this.cmTracker.getService();
            if (cm == null) {
                return;
            }
            Configuration config = cm.getConfiguration(PID);
            CMStorage cMStorage2 = this;
            synchronized (cMStorage2) {
                Log.debug("Store data into CM");
                config.update(provisioningData);
                ++this.counter;
            }
        }
        catch (IOException e) {
            Log.debug(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary props) {
        CMStorage e2;
        boolean register = false;
        CMStorage cMStorage = this;
        synchronized (cMStorage) {
            if (this.registering) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.sSReg == null && this.bc != null) {
                this.registering = true;
                register = true;
            }
        }
        if (register) {
            try {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.equinox.internal.ip.ProvisioningStorage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.sSReg = this.bc.registerService(clazz.getName(), (Object)this, null);
                Log.debug(this + " Registered.");
            }
            catch (Exception e2) {
                Log.debug(e2);
            }
            e2 = this;
            synchronized (e2) {
                this.registering = false;
                this.notifyAll();
            }
            return;
        }
        Log.debug("CM Storage Updated : counter = " + this.counter);
        e2 = this;
        synchronized (e2) {
            if (this.counter != 0) {
                --this.counter;
                return;
            }
        }
        if (props == null) {
            return;
        }
        ProvisioningService prvSrv = (ProvisioningService)this.prvSrvTracker.getService();
        if (prvSrv != null) {
            CMStorage cMStorage2 = this;
            synchronized (cMStorage2) {
                if (!this.infoLoaded) {
                    this.skipStore = true;
                    this.infoLoaded = true;
                }
            }
            prvSrv.addInformation(props);
        }
    }

    public String toString() {
        return "CM Storage";
    }
}

