/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.camel;

import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.camel.AbstractEndpointWireComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelConsume
extends AbstractEndpointWireComponent
implements WireEmitter {
    private static final Logger logger = LoggerFactory.getLogger(CamelConsume.class);
    private Endpoint endpoint;
    private Consumer consumer;
    private CamelContext camelContext;

    @Override
    protected void bindContext(CamelContext context) {
        try {
            this.stopConsumer();
            this.camelContext = context;
            this.startConsumer();
        }
        catch (Exception e) {
            logger.warn("Failed to bind Camel context", (Throwable)e);
        }
    }

    @Override
    public void setEndpointUri(String endpointUri) {
        if (this.endpointUri == null || !this.endpointUri.equals(endpointUri)) {
            try {
                this.stopConsumer();
                super.setEndpointUri(endpointUri);
                this.startConsumer();
            }
            catch (Exception e) {
                logger.warn("Failed to set endpoint URI", (Throwable)e);
            }
        }
    }

    private void startConsumer() throws Exception {
        if (this.camelContext == null) {
            return;
        }
        if (this.endpoint == null) {
            logger.info("Starting endpoint");
            this.endpoint = this.camelContext.getEndpoint(this.endpointUri);
            this.endpoint.start();
        }
        if (this.consumer == null) {
            logger.info("Starting consumer");
            this.consumer = this.endpoint.createConsumer(exchange -> this.processMessage(exchange.getIn()));
            this.consumer.start();
        }
    }

    private void stopConsumer() throws Exception {
        if (this.consumer != null) {
            logger.info("Stopping consumer");
            this.consumer.stop();
            this.consumer = null;
        }
        if (this.endpoint != null) {
            logger.info("Stopping endpoint");
            this.endpoint.stop();
            this.endpoint = null;
        }
    }

    private void processMessage(Message message) {
        logger.debug("Process message: {}", (Object)message);
        WireRecord[] records = (WireRecord[])message.getBody(WireRecord[].class);
        logger.debug("Consumed: {}", (Object)records);
        if (records != null) {
            this.wireSupport.emit(Arrays.asList(records));
        }
    }
}

