/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xinclude;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public enum XIncludeErrorCode implements IXMLErrorCode
{
    NoFallback,
    MultipleFallbacks,
    FallbackParent,
    IncludeChild,
    FallbackChild,
    HrefMissing,
    RecursiveInclude,
    InvalidParseValue,
    XMLParseError,
    XMLResourceError,
    TextResourceError,
    NonDuplicateNotation,
    NonDuplicateUnparsedEntity,
    XpointerMissing,
    AcceptMalformed,
    AcceptLanguageMalformed,
    RootElementRequired,
    MultipleRootElements,
    ContentIllegalAtTopLevel,
    UnexpandedEntityReferenceIllegal,
    HrefFragmentIdentifierIllegal,
    HrefSyntacticallyInvalid,
    XPointerStreamability,
    XPointerResolutionUnsuccessful;

    private final String code;
    private static final Map<String, XIncludeErrorCode> codes;

    private XIncludeErrorCode() {
        this(null);
    }

    private XIncludeErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static XIncludeErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, XIncludeErrorCode code, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (code) {
            case AcceptMalformed: {
                return XMLPositionUtility.selectAttributeValueAt("accept", offset, document);
            }
            case AcceptLanguageMalformed: {
                return XMLPositionUtility.selectAttributeValueAt("accept-language", offset, document);
            }
            case InvalidParseValue: {
                return XMLPositionUtility.selectAttributeValueAt("parse", offset, document);
            }
            case NoFallback: 
            case XMLResourceError: 
            case HrefFragmentIdentifierIllegal: 
            case HrefSyntacticallyInvalid: 
            case TextResourceError: 
            case XMLParseError: {
                return XMLPositionUtility.selectAttributeValueAt("href", offset, document);
            }
            case XPointerStreamability: 
            case XPointerResolutionUnsuccessful: {
                return XMLPositionUtility.selectAttributeValueAt("xpointer", offset, document);
            }
            case MultipleFallbacks: 
            case FallbackParent: 
            case IncludeChild: 
            case FallbackChild: 
            case HrefMissing: 
            case RecursiveInclude: 
            case NonDuplicateNotation: 
            case NonDuplicateUnparsedEntity: 
            case XpointerMissing: 
            case RootElementRequired: 
            case MultipleRootElements: 
            case ContentIllegalAtTopLevel: 
            case UnexpandedEntityReferenceIllegal: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
        }
        return null;
    }

    static {
        codes = new HashMap<String, XIncludeErrorCode>();
        for (XIncludeErrorCode errorCode : XIncludeErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

