/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import java.util.Arrays;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterPreserveSpacesTest {
    @Test
    public void noPreserveSpaces() throws BadLocationException {
        String content = "<a>b  c</a>";
        String expected = "<a>b c</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithXmlSpace() throws BadLocationException {
        String content;
        String expected = content = "<a xml:space=\"preserve\">b  c</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithXmlSpace2() throws BadLocationException {
        String content = "<a>\r\n  <b>\r\n    c  <d></d>  e\r\n  </b>\r\n  <b xml:space=\"preserve\">\r\n    c  <d></d>  e\r\n  </b>\r\n</a>";
        String expected = "<a>\r\n  <b> c <d></d> e </b>\r\n  <b xml:space=\"preserve\">\r\n    c  <d></d>  e\r\n  </b>\r\n</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(1, 5, 2, 4, " "), XMLAssert.te(2, 5, 2, 7, " "), XMLAssert.te(2, 14, 2, 16, " "), XMLAssert.te(2, 17, 3, 2, " "));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithSettings() throws BadLocationException {
        String content;
        String expected = content = "<a>b  c</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a"));
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void preserveSpacesWithDefaultSettings() throws BadLocationException {
        String content;
        String expected = content = "<xsl:text>b \r\n c</xsl:text>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTag() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a"));
        String expected = content = "<a>\n     </a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontPreserveEmptyContentTag() throws BadLocationException {
        String content = "<a>\n     </a>";
        String expected = "<a>\n</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 5, "\n"));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testPreserveTextContent() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a"));
        String expected = content = "<a>\n   aaa  </a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveTextContent2() throws BadLocationException {
        String content = "<a>\n   aaa   </a>";
        String expected = "<a>\n  aaa </a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 3, "\n  "), XMLAssert.te(1, 6, 1, 9, " "));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblings() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("b"));
        String content = "<a>\n       <b>  </b>     </a>";
        String expected = "<a>\n  <b>  </b>\n</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 7, "\n  "), XMLAssert.te(1, 16, 1, 21, "\n"));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblingContent() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a", "b"));
        String expected = content = "<a>\n   zz     <b>  </b>tt     </a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontPreserveEmptyContentTagWithSiblingContent() throws BadLocationException {
        String content = "<a>\n   zz     <b>  </b>tt     </a>";
        String expected = "<a> zz <b> </b>tt </a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 5, 1, 10, " "), XMLAssert.te(1, 13, 1, 15, " "), XMLAssert.te(1, 21, 1, 26, " "));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblingWithComment() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a", "b"));
        String expected = content = "<a>\n   zz    <b>  </b>tt <!-- Comment -->     </a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testPreserveEmptyContentTagWithSiblingWithNewLines() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveSpace(Arrays.asList("a", "b"));
        String expected = content = "<a>\n   zz    \n<b>\n  </b>\ntt <!-- Comment -->     </a>\n\n<c></c>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testDontPreserveEmptyContentTagWithSiblingWithComment() throws BadLocationException {
        String content = "<a>\n   zz    <b>  </b>tt <!-- Comment -->     </a>";
        String expected = "<a> zz <b> </b>tt <!-- Comment -->\n</a>";
        XMLFormatterPreserveSpacesTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 3, " "), XMLAssert.te(1, 5, 1, 9, " "), XMLAssert.te(1, 12, 1, 14, " "), XMLAssert.te(1, 37, 1, 42, "\n"));
        XMLFormatterPreserveSpacesTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveSpacesTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveSpacesTest.assertFormat(unformatted, expected, sharedSettings, "test.xml", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterPreserveSpacesTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

