/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement;

import com.google.gson.JsonObject;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclaration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement.required_elements_missing_expectedCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class required_elements_missing_expectedCodeAction
implements ICodeActionParticipant {
    private final Map<String, ICodeActionResolvesParticipant> resolveCodeActionParticipants = new HashMap<String, ICodeActionResolvesParticipant>();

    public required_elements_missing_expectedCodeAction() {
        this.resolveCodeActionParticipants.put(required_elements_missing_expectedCodeActionResolver.PARTICIPANT_ID, new required_elements_missing_expectedCodeActionResolver());
    }

    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        Diagnostic diagnostic = request.getDiagnostic();
        try {
            Range diagnosticRange = diagnostic.getRange();
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            String insertStr = null;
            if (node == null || !node.isElement()) {
                return;
            }
            DOMElement element = (DOMElement)node;
            XMLGenerator generator = request.getXMLGenerator();
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
                CMElementDeclaration matchesCMElement = cmDocument.findCMElement(element);
                if (matchesCMElement == null) continue;
                for (CMElementDeclaration child : ((CMRelaxNGElementDeclaration)matchesCMElement).getPossibleRequiredElements()) {
                    if (!request.canSupportResolve()) {
                        StringBuilder generatedXml = new StringBuilder();
                        generatedXml.append(generator.generate(child, null, true, false, 1, true));
                        insertStr = generatedXml.toString();
                    }
                    CodeAction insertElementCodeAction = required_elements_missing_expectedCodeAction.createInsertMissingElementCodeAction(child, element, insertStr, request, cancelChecker);
                    codeActions.add(insertElementCodeAction);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static CodeAction createInsertMissingElementCodeAction(CMElementDeclaration element, DOMElement domElement, String insertStr, ICodeActionRequest request, CancelChecker cancelChecker) throws BadLocationException {
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        String title = "Insert expected element '" + element.getLocalName() + "'";
        if (request.canSupportResolve()) {
            JsonObject data = DataEntryField.createData(document.getDocumentURI(), required_elements_missing_expectedCodeActionResolver.PARTICIPANT_ID);
            return required_elements_missing_expectedCodeAction.insertMissingExpectedElementUnresolvedCodeAction(title, diagnostic, data, element.getLocalName());
        }
        return required_elements_missing_expectedCodeAction.insertMissingExpectedElementCodeAction(document, title, domElement, insertStr, diagnostic);
    }

    private static CodeAction insertMissingExpectedElementUnresolvedCodeAction(String title, Diagnostic diagnostic, JsonObject data, String elementName) {
        CodeAction codeAction = new CodeAction(title);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        data.addProperty("element", elementName);
        codeAction.setData((Object)data);
        return codeAction;
    }

    @Override
    public ICodeActionResolvesParticipant getResolveCodeActionParticipant(String participantId) {
        return this.resolveCodeActionParticipants.get(participantId);
    }

    private static CodeAction insertMissingExpectedElementCodeAction(DOMDocument document, String title, DOMElement element, String insertStr, Diagnostic diagnostic) throws BadLocationException {
        Position childElementPositionStartTag = document.positionAt(element.getStartTagCloseOffset() + 1);
        Position childElementPositionEndTag = document.positionAt(element.getEndTagOpenOffset());
        Range targetRange = new Range(childElementPositionStartTag, childElementPositionEndTag);
        return CodeActionFactory.replace(title, targetRange, insertStr, document.getTextDocument(), diagnostic);
    }
}

