/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;

public class ContentModelFormatterParticipant
implements IFormatterParticipant {
    private final ContentModelManager contentModelManager;

    public ContentModelFormatterParticipant(ContentModelManager contentModelManager) {
        this.contentModelManager = contentModelManager;
    }

    @Override
    public FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints, Map<String, Collection<CMDocument>> formattingContext, SharedSettings sharedSettings) {
        Collection<CMDocument> cmDocuments;
        String namespaceURI;
        boolean enabled = sharedSettings.getFormattingSettings().isGrammarAwareFormatting();
        if (!enabled) {
            return null;
        }
        String string = namespaceURI = element.getNamespaceURI() != null ? element.getNamespaceURI() : element.getOwnerDocument().getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "noNameSpace";
        }
        if ((cmDocuments = formattingContext.get(namespaceURI)) == null) {
            try {
                cmDocuments = this.contentModelManager.findCMDocument(element);
            }
            catch (CacheResourceDownloadingException e) {
                try {
                    e.getFuture().get(2000L, TimeUnit.MILLISECONDS);
                    cmDocuments = this.contentModelManager.findCMDocument(element);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e1) {
                    return null;
                }
            }
            formattingContext.put(namespaceURI, cmDocuments);
        }
        for (CMDocument cmDocument : cmDocuments) {
            CMElementDeclaration cmElement = cmDocument.findCMElement(element);
            if (cmElement == null) continue;
            if (cmElement.isStringType()) {
                return FormatElementCategory.PreserveSpace;
            }
            if (!cmElement.isMixedContent()) continue;
            return FormatElementCategory.MixedContent;
        }
        return null;
    }

    @Override
    public boolean shouldCollapseEmptyElement(DOMElement element, SharedSettings sharedSettings) {
        boolean enabled = sharedSettings.getFormattingSettings().isGrammarAwareFormatting();
        if (!enabled) {
            return true;
        }
        if (!"true".equals(element.getAttribute("xsi:nil"))) {
            return true;
        }
        Collection<CMDocument> cmDocuments = this.contentModelManager.findCMDocument(element);
        if (cmDocuments.isEmpty()) {
            return true;
        }
        for (CMDocument cmDocument : cmDocuments) {
            CMElementDeclaration cmElement = cmDocument.findCMElement(element);
            if (cmElement == null || cmElement.isNillable()) continue;
            return false;
        }
        return true;
    }
}

