/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view.histogram;

import java.util.LinkedList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.internal.gprof.symbolManager.CallGraphNode;
import org.eclipse.linuxtools.internal.gprof.view.histogram.AbstractTreeElement;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistFile;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;

public class HistRoot
extends AbstractTreeElement {
    private final LinkedList<HistFile> children = new LinkedList();
    public final GmonDecoder decoder;

    public HistRoot(GmonDecoder decoder) {
        super(null);
        this.decoder = decoder;
    }

    private HistFile getChild(String p) {
        for (HistFile f : this.children) {
            if (!(p != null ? p.equals(f.sourcePath) : f.sourcePath == null)) continue;
            return f;
        }
        HistFile f = new HistFile(this, p);
        this.children.add(f);
        return f;
    }

    public void addBucket(Bucket b, IBinaryParser.ISymbol s, IBinaryParser.IBinaryObject program) {
        String path = this.decoder.getFileName(s);
        HistFile hf = this.getChild(path);
        hf.addBucket(b, s, program);
    }

    public void addCallGraphNode(CallGraphNode node) {
        IBinaryParser.ISymbol s = node.getSymbol();
        String path = this.decoder.getFileName(s);
        HistFile hf = this.getChild(path);
        hf.addCallGraphNode(node);
    }

    @Override
    public LinkedList<? extends TreeElement> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return Messages.HistRoot_Summary;
    }

    @Override
    public int getCalls() {
        return -1;
    }

    public IProject getProject() {
        return this.decoder.getProject();
    }
}

