/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInWorkspaceDialog;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInWorkspaceHandler
extends LSPDocumentAbstractHandler {
    @Override
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IResource resource = null;
        if (part != null && part.getEditorInput() != null) {
            resource = (IResource)part.getEditorInput().getAdapter(IResource.class);
        } else {
            IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
            Object object = selection.getFirstElement();
            if (object instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)object;
                resource = (IResource)adaptable.getAdapter(IResource.class);
            }
        }
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        LanguageServers.LanguageServerProjectExecutor executor = (LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(project).withCapability(ServerCapabilities::getWorkspaceSymbolProvider);
        if (!executor.anyMatching()) {
            return null;
        }
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (site == null) {
            return null;
        }
        BoldStylerProvider styleProvider = new BoldStylerProvider(site.getShell().getFont());
        LSPSymbolInWorkspaceDialog dialog = new LSPSymbolInWorkspaceDialog(site.getShell(), project, styleProvider);
        int code = dialog.open();
        styleProvider.dispose();
        if (code != 0) {
            return null;
        }
        Object object = dialog.getFirstResult();
        if (object instanceof WorkspaceSymbol) {
            WorkspaceSymbol wsSymbol = (WorkspaceSymbol)object;
            Either symbolInformation = wsSymbol.getLocation();
            if (symbolInformation.isLeft()) {
                LSPEclipseUtils.openInEditor((Location)symbolInformation.getLeft());
            } else if (symbolInformation.isRight()) {
                LSPEclipseUtils.open(((WorkspaceSymbolLocation)symbolInformation.getRight()).getUri(), null);
            }
        }
        return null;
    }

    @Override
    protected void execute(ExecutionEvent event, ITextEditor textEditor) {
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        this.setEnabled(ServerCapabilities::getWorkspaceSymbolProvider, (ITextEditor x) -> true);
    }
}

