/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.color;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.AbstractLSPCodeMiningProvider;
import org.eclipse.lsp4e.operations.color.ColorInformationMining;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;

public class DocumentColorProvider
extends AbstractLSPCodeMiningProvider {
    private final Map<RGBA, Color> colorTable = new HashMap<RGBA, Color>();

    @Override
    protected @Nullable CompletableFuture<List<? extends ICodeMining>> doProvideCodeMinings(IDocument document, TextDocumentIdentifier docId) {
        DocumentColorParams param = new DocumentColorParams(docId);
        return ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getColorProvider)).collectAll((wrapper, ls) -> ls.getTextDocumentService().documentColor(param).thenApply(colors -> LanguageServers.streamSafely(colors).map(color -> this.toMining((ColorInformation)color, document, docId, (LanguageServerWrapper)wrapper)))).thenApply(res -> res.stream().flatMap(Function.identity()).filter(Objects::nonNull).toList());
    }

    private @Nullable ColorInformationMining toMining(ColorInformation color, IDocument document, TextDocumentIdentifier textDocumentIdentifier, LanguageServerWrapper wrapper) {
        try {
            return new ColorInformationMining(color, document, textDocumentIdentifier, wrapper, this);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    public Color getColor(RGBA rgba, Display display) {
        return this.colorTable.computeIfAbsent(rgba, key -> new Color((Device)display, rgba));
    }
}

