/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.jaxrs;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class ResourceMethodTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void NonPublicMethod() throws Exception {
        IJavaProject javaProject = ResourceMethodTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jaxrs/NotPublicResourceMethod.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d = JakartaForJavaAssert.d(20, 17, 30, "Only public methods can be exposed as resource methods.", DiagnosticSeverity.Error, "jakarta-jaxrs", "NonPublicResourceMethod");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d);
        TextEdit te = JakartaForJavaAssert.te(20, 4, 20, 11, "public");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Make method public", d, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
    }

    @Test
    public void multipleEntityParamsMethod() throws Exception {
        IJavaProject javaProject = ResourceMethodTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jaxrs/MultipleEntityParamsResourceMethod.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 13, 46, "Resource methods cannot have more than one entity parameter.", DiagnosticSeverity.Error, "jakarta-jaxrs", "ResourceMethodMultipleEntityParams");
        Diagnostic d2 = JakartaForJavaAssert.d(34, 13, 55, "Resource methods cannot have more than one entity parameter.", DiagnosticSeverity.Error, "jakarta-jaxrs", "ResourceMethodMultipleEntityParams");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te1 = JakartaForJavaAssert.te(22, 112, 22, 130, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove all entity parameters except entityParam1", d1, te1);
        TextEdit te2 = JakartaForJavaAssert.te(22, 47, 22, 68, "");
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove all entity parameters except entityParam2", d1, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, IJDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te3 = JakartaForJavaAssert.te(34, 56, 34, 77, "");
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Remove all entity parameters except entityInt", d1, te3);
        TextEdit te4 = JakartaForJavaAssert.te(34, 77, 34, 92, "");
        CodeAction ca4 = JakartaForJavaAssert.ca(uri, "Remove all entity parameters except entityString", d1, te4);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, IJDT_UTILS, ca3, ca4);
    }
}

