/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.codeaction;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.java.AbstractJavaContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IInvocationContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ChangeCorrectionProposal;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.ChangeUtil;

public class JavaCodeActionContext
extends AbstractJavaContext
implements IInvocationContext {
    private final int selectionOffset;
    private final int selectionLength;
    private final JakartaJavaCodeActionParams params;
    private NodeFinder fNodeFinder;

    public JavaCodeActionContext(ITypeRoot typeRoot, int selectionOffset, int selectionLength, IJDTUtils utils, JakartaJavaCodeActionParams params) {
        super(params.getUri(), typeRoot, utils);
        this.selectionOffset = selectionOffset;
        this.selectionLength = selectionLength;
        this.params = params;
    }

    public JakartaJavaCodeActionParams getParams() {
        return this.params;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getTypeRoot();
    }

    @Override
    public int getSelectionLength() {
        return this.selectionLength;
    }

    @Override
    public int getSelectionOffset() {
        return this.selectionOffset;
    }

    @Override
    public ASTNode getCoveringNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.selectionOffset, this.selectionLength);
        }
        return this.fNodeFinder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.selectionOffset, this.selectionLength);
        }
        return this.fNodeFinder.getCoveredNode();
    }

    public CodeAction convertToCodeAction(ChangeCorrectionProposal proposal, Diagnostic ... diagnostics) throws CoreException {
        String name = proposal.getName();
        WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange(), this.getUri(), this.getUtils(), this.params.isResourceOperationSupported());
        if (!ChangeUtil.hasChanges(edit)) {
            return null;
        }
        ExtendedCodeAction codeAction = new ExtendedCodeAction(name);
        codeAction.setRelevance(proposal.getRelevance());
        codeAction.setKind(proposal.getKind());
        codeAction.setEdit(edit);
        codeAction.setDiagnostics(Arrays.asList(diagnostics));
        return codeAction;
    }

    public WorkspaceEdit convertToWorkspaceEdit(ChangeCorrectionProposal proposal) throws CoreException {
        WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange(), this.getUri(), this.getUtils(), this.params.isResourceOperationSupported());
        if (!ChangeUtil.hasChanges(edit)) {
            return null;
        }
        return edit;
    }
}

