/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvt.environment;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.qvt.declarative.ecore.utils.CSTFormattingHelper;
import org.eclipse.qvt.declarative.parser.qvt.environment.IQVTNodeEnvironment;

public class QVTFormattingHelper
extends CSTFormattingHelper {
    protected final IQVTNodeEnvironment environment;

    public QVTFormattingHelper(IQVTNodeEnvironment environment) {
        this.environment = environment;
    }

    public String formatQualifiedName(Object object) {
        EClassifier referredType;
        if (object instanceof PrimitiveType) {
            return this.formatName(object);
        }
        if (object instanceof CollectionType) {
            return this.formatName(object);
        }
        if (object instanceof TypeType && (referredType = (EClassifier)((TypeType)object).getReferredType()) != null) {
            return "Type(" + this.formatQualifiedName(referredType) + ")";
        }
        if (object instanceof OCLExpression) {
            return object.toString();
        }
        if (object instanceof EObject) {
            Resource resource;
            EObject eObject = (EObject)object;
            EObject container = eObject.eContainer();
            if (container != null) {
                return String.valueOf(this.formatQualifiedName(container)) + this.getSeparator() + this.formatName(object);
            }
            String prefix = this.environment.getModelName(eObject);
            if (prefix == null && (resource = eObject.eResource()) != null) {
                prefix = this.formatResource(resource);
            }
            if (prefix != null) {
                return String.valueOf(prefix) + this.getSeparator() + this.formatName(object);
            }
        }
        return this.formatName(object);
    }
}

