/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractTransformerInternal;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalObjectManager;

public class ModificationMonitor
implements Adapter {
    private final  @NonNull AbstractTransformerInternal.Model.Incremental typedModelInstance;
    private final @NonNull Resource resource;
    private final @NonNull TransformationExecutor executor;
    private final @NonNull AbstractTransformer.Incremental transformer;
    private final @NonNull IncrementalObjectManager objectManager;
    private @Nullable Deque<@NonNull Notification> notifications = null;
    private boolean isDisabled = false;

    public static @Nullable ModificationMonitor basicGetModificationMonitor(@NonNull Resource resource, @NonNull TransformationExecutor executor) {
        for (Adapter eAdapter : resource.eAdapters()) {
            ModificationMonitor monitor;
            if (!(eAdapter instanceof ModificationMonitor) || (monitor = (ModificationMonitor)eAdapter).getExecutor() != executor) continue;
            return monitor;
        }
        return null;
    }

    public static @NonNull ModificationMonitor getModificationMonitor(@NonNull TypedModelInstance typedModelInstance, @NonNull Resource resource, @NonNull TransformationExecutor executor) {
        EList eAdapters = resource.eAdapters();
        for (Adapter eAdapter : eAdapters) {
            ModificationMonitor monitor;
            if (!(eAdapter instanceof ModificationMonitor) || (monitor = (ModificationMonitor)eAdapter).getExecutor() != executor) continue;
            return monitor;
        }
        ModificationMonitor monitor = new ModificationMonitor(typedModelInstance, resource, executor);
        for (EObject eObject : new TreeIterable(resource)) {
            eObject.eAdapters().add((Object)monitor);
        }
        eAdapters.add(monitor);
        return monitor;
    }

    public ModificationMonitor(@NonNull TypedModelInstance typedModelInstance, @NonNull Resource resource, @NonNull TransformationExecutor executor) {
        this.typedModelInstance = (AbstractTransformerInternal.Model.Incremental)typedModelInstance;
        this.resource = resource;
        this.executor = executor;
        this.transformer = (AbstractTransformer.Incremental)executor.getTransformer();
        this.objectManager = (IncrementalObjectManager)this.transformer.getObjectManager();
    }

    protected void addEObject(@NonNull EObject newValue) {
        for (EObject eObject : new TreeIterable(newValue, true)) {
            eObject.eAdapters().add((Object)this);
        }
        this.typedModelInstance.add(newValue, false);
        for (EObject eObject : new TreeIterable(newValue, false)) {
            this.typedModelInstance.add(eObject, true);
        }
    }

    public void dispose() {
        this.isDisabled = true;
        Deque<@NonNull Notification> notifications2 = this.notifications;
        if (notifications2 != null) {
            notifications2.clear();
        }
    }

    public @NonNull TransformationExecutor getExecutor() {
        return this.executor;
    }

    public @NonNull Resource getTarget() {
        return this.resource;
    }

    public boolean isAdapterForType(Object type) {
        return type == ModificationMonitor.class;
    }

    public void notifyChanged(Notification notification) {
        if (this.isDisabled) {
            return;
        }
        assert (notification != null);
        if (notification.isTouch()) {
            return;
        }
        Deque<@NonNull Notification> notifications2 = this.notifications;
        if (notifications2 != null) {
            notifications2.add(notification);
            return;
        }
        notifications2 = this.notifications = new ArrayDeque<Notification>();
        block7: do {
            int eventType = notification.getEventType();
            switch (eventType) {
                case 3: {
                    EObject object2 = (EObject)notification.getNewValue();
                    assert (object2 != null);
                    this.addEObject(object2);
                    break;
                }
                case 4: {
                    EObject object2 = (EObject)notification.getOldValue();
                    assert (object2 != null);
                    this.removeEObject(object2);
                    break;
                }
                case 5: {
                    EObject object2;
                    for (Object object : (Iterable)notification.getNewValue()) {
                        object2 = (EObject)object;
                        assert (object2 != null);
                        this.addEObject(object2);
                    }
                    continue block7;
                }
                case 6: {
                    EObject object2;
                    for (Object object : (Iterable)notification.getOldValue()) {
                        object2 = (EObject)object;
                        assert (object2 != null);
                        this.removeEObject(object2);
                    }
                    continue block7;
                }
                case 1: 
                case 2: {
                    Object notifier = notification.getNotifier();
                    assert (notifier != null);
                    Object feature = notification.getFeature();
                    if (!(feature instanceof EStructuralFeature)) break;
                    this.objectManager.modified(notifier, (EStructuralFeature)feature);
                }
            }
        } while ((notification = notifications2.peek() != null ? notifications2.pop() : null) != null);
        this.notifications = null;
    }

    protected void removeEObject(@NonNull EObject oldValue) {
        for (EObject eObject : new TreeIterable(oldValue, true)) {
            eObject.eAdapters().remove((Object)this);
        }
        IncrementalObjectManager objectManager = (IncrementalObjectManager)this.executor.getTransformer().getObjectManager();
        for (EObject eObject : new TreeIterable(oldValue, true)) {
            this.typedModelInstance.remove(eObject);
            objectManager.destroyed(eObject);
        }
    }

    public void setTarget(Notifier newTarget) {
    }
}

