/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;

public abstract class AbstractCyclicPartialRegionsAnalysis<@NonNull PRA extends PartialRegionsAnalysis<@NonNull PRA>> {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void showCycles(@NonNull TracingOption cyclesTracingOption, @NonNull Iterable<? extends @NonNull PartialRegionAnalysis<@NonNull PRA>> cyclicRegionAnalyses) {
        @NonNull @NonNull ArrayList sortedCyclicRegionAnalyses = Lists.newArrayList(cyclicRegionAnalyses);
        if (sortedCyclicRegionAnalyses.isEmpty()) {
            cyclesTracingOption.println("No cycles");
            return;
        }
        Collections.sort(sortedCyclicRegionAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionAnalysis cyclicRegionAnalysis : sortedCyclicRegionAnalyses) {
            Iterable producedPropertyAnalyses;
            Iterable consumedPropertyAnalyses;
            Iterable superProducedClassAnalyses;
            StringBuilder s = new StringBuilder();
            s.append(cyclicRegionAnalysis.getName());
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> consumedClassAnalyses = cyclicRegionAnalysis.getConsumedClassAnalyses();
            if (consumedClassAnalyses != null) {
                s.append("\n  ConsumedClassAnalyses:");
                @NonNull @NonNull ArrayList sortedConsumedClassAnalyses = Lists.newArrayList(consumedClassAnalyses);
                Collections.sort(sortedConsumedClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionClassAnalysis consumedClassAnalysis : sortedConsumedClassAnalyses) {
                    s.append("\n\t" + consumedClassAnalysis);
                }
            }
            if ((superProducedClassAnalyses = cyclicRegionAnalysis.getSuperProducedClassAnalyses()) != null) {
                s.append("\n  ProducedClassAnalyses:");
                @NonNull @NonNull ArrayList sortedSuperProducedClassAnalyses = Lists.newArrayList(superProducedClassAnalyses);
                Collections.sort(sortedSuperProducedClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionClassAnalysis producedClassAnalysis : sortedSuperProducedClassAnalyses) {
                    s.append("\n\t" + producedClassAnalysis);
                }
            }
            if ((consumedPropertyAnalyses = cyclicRegionAnalysis.getConsumedPropertyAnalyses()) != null) {
                s.append("\n  ConsumedPropertyAnalyses:");
                @NonNull @NonNull ArrayList sortedConsumedPropertyAnalyses = Lists.newArrayList(consumedPropertyAnalyses);
                Collections.sort(sortedConsumedPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionPropertyAnalysis consumedPropertyAnalysis : sortedConsumedPropertyAnalyses) {
                    s.append("\n\t" + consumedPropertyAnalysis + "(" + consumedPropertyAnalysis.getBasePropertyAnalysis() + ")");
                }
            }
            if ((producedPropertyAnalyses = cyclicRegionAnalysis.getProducedPropertyAnalyses()) != null) {
                s.append("\n  ProducedPropertyAnalyses:");
                @NonNull @NonNull ArrayList sortedProducedPropertyAnalyses = Lists.newArrayList(producedPropertyAnalyses);
                Collections.sort(sortedProducedPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionPropertyAnalysis producedPropertyAnalysis : sortedProducedPropertyAnalyses) {
                    s.append("\n\t" + producedPropertyAnalysis + "(" + producedPropertyAnalysis.getBasePropertyAnalysis() + ")");
                }
            }
            cyclesTracingOption.println(s.toString());
        }
    }
}

