/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.wizards;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class PersistedValuesWizard
extends Wizard {
    private static final int SECTIONS_DIFFERENT = -1;
    private static final int SECTIONS_EQUAL = 0;
    private static final int SECTIONS_EQUAL_WITH_IMPLIED = 1;
    private final AbstractUIPlugin myPlugin;
    public final String TIMESTAMP = "org.eclipse.m2m.internal.qvt.oml.common.wizards.PersistedValuesWizard.timestamp";
    public final int MAX_RECORDS = 20;

    public PersistedValuesWizard(AbstractUIPlugin plugin) {
        this.myPlugin = plugin;
    }

    protected abstract void saveValues();

    protected abstract boolean performFinishBody();

    public final boolean performFinish() {
        boolean result = this.performFinishBody();
        if (result) {
            this.saveValues();
        }
        return result;
    }

    public PreferenceSection loadValues(Map keys) {
        PreferenceSection result;
        IDialogSettings section = this.myPlugin.getDialogSettings().getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = this.myPlugin.getDialogSettings().addNewSection(((Object)((Object)this)).getClass().getName());
        }
        String name = "0";
        IDialogSettings[] sections = section.getSections();
        if (sections == null || sections.length == 0) {
            result = new PreferenceSection(section, name);
        } else {
            IDialogSettings resSection = null;
            int i = 0;
            while (i < sections.length) {
                int equal = this.checkSectionEquals(sections[i], keys);
                switch (equal) {
                    case 0: {
                        if (resSection != null && resSection.getLong("org.eclipse.m2m.internal.qvt.oml.common.wizards.PersistedValuesWizard.timestamp") >= sections[i].getLong("org.eclipse.m2m.internal.qvt.oml.common.wizards.PersistedValuesWizard.timestamp")) break;
                        resSection = sections[i];
                        break;
                    }
                    case 1: {
                        if (resSection != null) break;
                        resSection = sections[i];
                    }
                }
                ++i;
            }
            result = resSection == null ? this.getFreeSubsection(section) : new PreferenceSection(resSection, false);
        }
        this.initSection(result, keys);
        return result;
    }

    protected PreferenceSection loadValues(String key, String value) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put(key, value);
        return this.loadValues(keys);
    }

    protected PreferenceSection loadValues(String key1, String value1, String key2, String value2) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put(key1, value1);
        keys.put(key2, value2);
        return this.loadValues(keys);
    }

    private PreferenceSection getFreeSubsection(IDialogSettings section) {
        IDialogSettings[] subsections = section.getSections();
        if (subsections == null) {
            return new PreferenceSection(section, "0");
        }
        if (subsections.length < 20) {
            return new PreferenceSection(section, String.valueOf(subsections.length));
        }
        IDialogSettings toReplace = subsections[0];
        int i = 1;
        while (i < subsections.length) {
            if (toReplace.getLong("org.eclipse.m2m.internal.qvt.oml.common.wizards.PersistedValuesWizard.timestamp") > subsections[i].getLong("org.eclipse.m2m.internal.qvt.oml.common.wizards.PersistedValuesWizard.timestamp")) {
                toReplace = subsections[i];
            }
            ++i;
        }
        return new PreferenceSection(toReplace, true);
    }

    private int checkSectionEquals(IDialogSettings section, Map keys) {
        int result = 0;
        for (String key : keys.keySet()) {
            String value = section.get(key);
            if (keys.get(key).equals(value)) continue;
            if (value == null) {
                result = 1;
                continue;
            }
            return -1;
        }
        return result;
    }

    private void initSection(PreferenceSection section, Map keys) {
        section.put("org.eclipse.m2m.internal.qvt.oml.common.wizards.PersistedValuesWizard.timestamp", new Date().getTime());
        for (String key : keys.keySet()) {
            section.put(key, (String)keys.get(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PreferenceSection {
        private IDialogSettings myParent;
        private String myName;
        private IDialogSettings mySection;
        private final Map<String, Object> myCache = new HashMap<String, Object>();
        private final boolean myErased;
        public static final boolean ERASE_DATA = true;
        public static final boolean DONT_ERASE_DATA = false;

        private PreferenceSection(IDialogSettings section, boolean eraseData) {
            this.mySection = section;
            this.myErased = eraseData;
        }

        private PreferenceSection(IDialogSettings parent, String name) {
            this.myParent = parent;
            this.myName = name;
            this.mySection = null;
            this.myErased = false;
        }

        public void put(String key, String value) {
            this.myCache.put(key, value);
        }

        public void put(String key, boolean value) {
            this.myCache.put(key, new Boolean(value));
        }

        public void put(String key, long value) {
            this.myCache.put(key, new Long(value));
        }

        public void put(String key, Map<String, String> value) {
            String[] values = new String[value.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> entry : value.entrySet()) {
                values[i] = entry.getKey();
                values[i + 1] = entry.getValue();
                i += 2;
            }
            this.myCache.put(key, values);
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            String result = defaultValue;
            if (!this.myCache.containsKey(key)) {
                if (!this.myErased && this.mySection != null) {
                    result = this.mySection.get(key);
                    this.myCache.put(key, result);
                }
            } else {
                result = (String)this.myCache.get(key);
            }
            return result;
        }

        public boolean getBoolean(String key) {
            return this.getBoolean(key, false);
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            boolean result = defaultValue;
            if (!this.myCache.containsKey(key)) {
                if (!this.myErased && this.mySection != null) {
                    result = this.mySection.getBoolean(key);
                    this.myCache.put(key, new Boolean(result));
                }
            } else {
                result = (Boolean)this.myCache.get(key);
            }
            return result;
        }

        public Map<String, String> getStringMap(String key) {
            HashMap<String, String> result = Collections.emptyMap();
            if (!this.myCache.containsKey(key)) {
                String[] values;
                if (!this.myErased && this.mySection != null && (values = this.mySection.getArray(key)) != null) {
                    result = new HashMap<String, String>();
                    int i = 0;
                    while (i < values.length) {
                        result.put(values[i], i + 1 < values.length ? values[i + 1] : null);
                        i += 2;
                    }
                    this.myCache.put(key, result);
                }
            } else {
                result = (HashMap<String, String>)this.myCache.get(key);
            }
            return result;
        }

        public void save() {
            if (this.mySection == null) {
                this.mySection = this.myParent.addNewSection(this.myName);
            }
            for (Map.Entry<String, Object> entry : this.myCache.entrySet()) {
                if (entry.getValue() instanceof String[]) {
                    String[] values = (String[])entry.getValue();
                    this.mySection.put(entry.getKey(), values);
                    continue;
                }
                if (entry.getValue() == null) continue;
                this.mySection.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }
}

