/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.mergeresolution;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.ui.internal.mergeresolution.MergeResolutionListenerRegistry;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.TreeNodeCompareInput;
import org.eclipse.emf.compare.ide.ui.mergeresolution.MergeResolutionManager;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MergeResolutionManagerTest {
    MergeResolutionListenerRegistry registry;
    MergeResolutionManager sut;

    @Before
    public void setUp() {
        this.registry = (MergeResolutionListenerRegistry)Mockito.mock(MergeResolutionListenerRegistry.class);
        this.sut = new MergeResolutionManager(this.registry);
    }

    @Test
    public void testPositiveMatch() {
        Comparison comparison = this.prepareComparison(true);
        Match match = (Match)Mockito.mock(Match.class);
        Mockito.when((Object)match.getComparison()).thenReturn((Object)comparison);
        TreeNodeCompareInput input = (TreeNodeCompareInput)Mockito.mock(TreeNodeCompareInput.class);
        Mockito.when((Object)input.getComparisonObject()).thenReturn((Object)match);
        this.sut.handleFlush((Object)input);
        ((MergeResolutionListenerRegistry)Mockito.verify((Object)this.registry)).mergeResolutionCompleted((Comparison)Matchers.any(Comparison.class));
    }

    @Test
    public void testNegativeMatch() {
        Comparison comparison = this.prepareComparison(false);
        Match match = (Match)Mockito.mock(Match.class);
        Mockito.when((Object)match.getComparison()).thenReturn((Object)comparison);
        TreeNodeCompareInput input = (TreeNodeCompareInput)Mockito.mock(TreeNodeCompareInput.class);
        Mockito.when((Object)input.getComparisonObject()).thenReturn((Object)match);
        this.sut.handleFlush((Object)input);
        ((MergeResolutionListenerRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).mergeResolutionCompleted((Comparison)Matchers.any(Comparison.class));
    }

    @Test
    public void testPositiveDiff() {
        Comparison comparison = this.prepareComparison(true);
        Diff diff = (Diff)Mockito.mock(Diff.class);
        Match match = (Match)Mockito.mock(Match.class);
        Mockito.when((Object)diff.getMatch()).thenReturn((Object)match);
        Mockito.when((Object)match.getComparison()).thenReturn((Object)comparison);
        TreeNodeCompareInput input = (TreeNodeCompareInput)Mockito.mock(TreeNodeCompareInput.class);
        Mockito.when((Object)input.getComparisonObject()).thenReturn((Object)diff);
        this.sut.handleFlush((Object)input);
        ((MergeResolutionListenerRegistry)Mockito.verify((Object)this.registry)).mergeResolutionCompleted((Comparison)Matchers.any(Comparison.class));
    }

    @Test
    public void testNegativeDiff() {
        Comparison comparison = this.prepareComparison(false);
        Diff diff = (Diff)Mockito.mock(Diff.class);
        Match match = (Match)Mockito.mock(Match.class);
        Mockito.when((Object)diff.getMatch()).thenReturn((Object)match);
        Mockito.when((Object)match.getComparison()).thenReturn((Object)comparison);
        TreeNodeCompareInput input = (TreeNodeCompareInput)Mockito.mock(TreeNodeCompareInput.class);
        Mockito.when((Object)input.getComparisonObject()).thenReturn((Object)diff);
        this.sut.handleFlush((Object)input);
        ((MergeResolutionListenerRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).mergeResolutionCompleted((Comparison)Matchers.any(Comparison.class));
    }

    @Test
    public void testPositiveMatchResource() {
        Comparison comparison = this.prepareComparison(true);
        MatchResource matchResource = (MatchResource)Mockito.mock(MatchResource.class);
        Mockito.when((Object)matchResource.getComparison()).thenReturn((Object)comparison);
        TreeNodeCompareInput input = (TreeNodeCompareInput)Mockito.mock(TreeNodeCompareInput.class);
        Mockito.when((Object)input.getComparisonObject()).thenReturn((Object)matchResource);
        this.sut.handleFlush((Object)input);
        ((MergeResolutionListenerRegistry)Mockito.verify((Object)this.registry)).mergeResolutionCompleted((Comparison)Matchers.any(Comparison.class));
    }

    @Test
    public void testNegativeMatchResource() {
        Comparison comparison = this.prepareComparison(false);
        MatchResource matchResource = (MatchResource)Mockito.mock(MatchResource.class);
        Mockito.when((Object)matchResource.getComparison()).thenReturn((Object)comparison);
        TreeNodeCompareInput input = (TreeNodeCompareInput)Mockito.mock(TreeNodeCompareInput.class);
        Mockito.when((Object)input.getComparisonObject()).thenReturn((Object)matchResource);
        this.sut.handleFlush((Object)input);
        ((MergeResolutionListenerRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).mergeResolutionCompleted((Comparison)Matchers.any(Comparison.class));
    }

    private Comparison prepareComparison(boolean allResolved) {
        Comparison comparison = (Comparison)Mockito.mock(Comparison.class);
        BasicEList conflicts = new BasicEList();
        conflicts.add((Object)this.createConflict(true));
        conflicts.add((Object)this.createConflict(true));
        conflicts.add((Object)this.createConflict(true));
        conflicts.add((Object)this.createConflict(allResolved));
        Mockito.when((Object)comparison.getConflicts()).thenReturn((Object)conflicts);
        return comparison;
    }

    private Conflict createConflict(boolean resolved) {
        Conflict conflict = (Conflict)Mockito.mock(Conflict.class);
        BasicEList differences = new BasicEList();
        differences.add((Object)this.createResolvedDiff(DifferenceState.MERGED));
        differences.add((Object)this.createResolvedDiff(DifferenceState.MERGED));
        differences.add((Object)this.createResolvedDiff(DifferenceState.DISCARDED));
        if (!resolved) {
            differences.add((Object)this.createResolvedDiff(DifferenceState.UNRESOLVED));
        }
        Mockito.when((Object)conflict.getDifferences()).thenReturn((Object)differences);
        return conflict;
    }

    private Diff createResolvedDiff(DifferenceState state) {
        Diff diff = (Diff)Mockito.mock(Diff.class);
        Mockito.when((Object)diff.getState()).thenReturn((Object)state);
        return diff;
    }
}

