/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.RenameDetector;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.tests.logical.resolver.SimilarityComputerTest;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class RenameDetectorTest {
    RenameDetector sut;
    Subscriber subscriber;
    IStorageProviderAccessor accessor;
    IProject root;
    Map<IFile, String> contentsOrigin = new HashMap<IFile, String>();
    Map<IFile, String> contentsSource = new HashMap<IFile, String>();
    Map<IFile, String> contentsRemote = new HashMap<IFile, String>();

    @Before
    public void setUp() {
        this.subscriber = (Subscriber)Mockito.mock(Subscriber.class);
        this.accessor = (IStorageProviderAccessor)Mockito.mock(IStorageProviderAccessor.class);
        this.sut = new RenameDetector(this.subscriber, this.accessor);
        this.root = (IProject)Mockito.mock(IProject.class);
        Mockito.when((Object)this.subscriber.roots()).thenReturn((Object)new IResource[]{this.root});
    }

    @Test
    public void testNoChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsRemote.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
    }

    @Test
    public void testRenameSourceNoChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        IFile fileB2 = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB2, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsRemote.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertSame((Object)fileB2, (Object)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).get());
        Assert.assertSame((Object)fileB, (Object)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).get());
    }

    @Test
    public void testRenameRemoteNoChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        IFile fileB2 = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsRemote.put(fileB2, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertSame((Object)fileB2, (Object)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).get());
        Assert.assertSame((Object)fileB, (Object)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).get());
    }

    @Test
    public void testRenameSourceSlightChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        IFile fileB2 = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB2, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2, slight change\nbla\n");
        this.contentsRemote.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertSame((Object)fileB2, (Object)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).get());
        Assert.assertSame((Object)fileB, (Object)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).get());
    }

    @Test
    public void testRenameRemoteSlightChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        IFile fileB2 = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsRemote.put(fileB2, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2, slight change\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertTrue((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertSame((Object)fileB2, (Object)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).get());
        Assert.assertSame((Object)fileB, (Object)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).get());
    }

    @Test
    public void testRenameSourceBigChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        IFile fileB2 = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB2, String.valueOf(SimilarityComputerTest.PREFIX) + "contents2, slight change\nbla\n");
        this.contentsRemote.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
    }

    @Test
    public void testRenameRemoteBigChange() throws CoreException, UnsupportedEncodingException {
        IFile fileA = (IFile)Mockito.mock(IFile.class);
        IFile fileB = (IFile)Mockito.mock(IFile.class);
        IFile fileB2 = (IFile)Mockito.mock(IFile.class);
        this.contentsOrigin.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsSource.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsRemote.put(fileA, String.valueOf(SimilarityComputerTest.PREFIX) + "contents\nbla\n");
        this.contentsOrigin.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsSource.put(fileB, String.valueOf(SimilarityComputerTest.PREFIX2) + "contents2\nbla\n");
        this.contentsRemote.put(fileB2, String.valueOf(SimilarityComputerTest.PREFIX) + "contents2, slight change\nbla\n");
        this.processContents();
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileA, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileAfterRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.SOURCE).isPresent());
        Assert.assertFalse((boolean)this.sut.getFileBeforeRename(fileB2, IStorageProviderAccessor.DiffSide.REMOTE).isPresent());
    }

    private void processContents() throws CoreException, UnsupportedEncodingException {
        HashSet<IFile> files = new HashSet<IFile>();
        files.addAll(this.contentsOrigin.keySet());
        files.addAll(this.contentsSource.keySet());
        files.addAll(this.contentsRemote.keySet());
        for (IFile file : files) {
            String originContent = this.contentsOrigin.get(file);
            String remoteContent = this.contentsRemote.get(file);
            String sourceContent = this.contentsSource.get(file);
            int remoteDiffKind = this.diffKind(originContent, remoteContent);
            int sourceDiffKind = this.diffKind(originContent, sourceContent);
            ThreeWayDiff threeWayDiff = (ThreeWayDiff)Mockito.mock(ThreeWayDiff.class);
            ITwoWayDiff remoteDiff = (ITwoWayDiff)Mockito.mock(ITwoWayDiff.class);
            ITwoWayDiff sourceDiff = (ITwoWayDiff)Mockito.mock(ITwoWayDiff.class);
            Mockito.when((Object)remoteDiff.getKind()).thenReturn((Object)remoteDiffKind);
            Mockito.when((Object)sourceDiff.getKind()).thenReturn((Object)sourceDiffKind);
            Mockito.when((Object)threeWayDiff.getLocalChange()).thenReturn((Object)sourceDiff);
            Mockito.when((Object)threeWayDiff.getRemoteChange()).thenReturn((Object)remoteDiff);
            Mockito.when((Object)this.subscriber.getDiff((IResource)file)).thenReturn((Object)threeWayDiff);
            IStorageProvider originProvider = (IStorageProvider)Mockito.mock(IStorageProvider.class);
            IStorageProvider remoteProvider = (IStorageProvider)Mockito.mock(IStorageProvider.class);
            IStorageProvider sourceProvider = (IStorageProvider)Mockito.mock(IStorageProvider.class);
            IStorage originStorage = (IStorage)Mockito.mock(IStorage.class);
            IStorage remoteStorage = (IStorage)Mockito.mock(IStorage.class);
            IStorage sourceStorage = (IStorage)Mockito.mock(IStorage.class);
            Mockito.when((Object)originProvider.getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class))).thenReturn((Object)originStorage);
            Mockito.when((Object)remoteProvider.getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class))).thenReturn((Object)remoteStorage);
            Mockito.when((Object)sourceProvider.getStorage((IProgressMonitor)Matchers.any(IProgressMonitor.class))).thenReturn((Object)sourceStorage);
            Mockito.when((Object)originStorage.getContents()).then(this.openInputStream(originContent));
            Mockito.when((Object)remoteStorage.getContents()).then(this.openInputStream(remoteContent));
            Mockito.when((Object)sourceStorage.getContents()).then(this.openInputStream(sourceContent));
            Mockito.when((Object)this.accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.ORIGIN)).thenReturn((Object)originProvider);
            Mockito.when((Object)this.accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.REMOTE)).thenReturn((Object)remoteProvider);
            Mockito.when((Object)this.accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.SOURCE)).thenReturn((Object)sourceProvider);
        }
        Mockito.when((Object)this.subscriber.members((IResource)this.root)).thenReturn((Object)((IResource[])files.toArray(new IFile[0])));
    }

    private Answer<?> openInputStream(String content) throws UnsupportedEncodingException {
        final byte[] bytes = content == null ? null : content.getBytes("UTF-8");
        return new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) throws Throwable {
                return bytes == null ? null : new ByteArrayInputStream(bytes);
            }
        };
    }

    private int diffKind(String originContent, String branchContent) {
        if (originContent == null && branchContent == null) {
            return 0;
        }
        if (originContent == null) {
            return 1;
        }
        if (branchContent == null) {
            return 2;
        }
        return 4;
    }
}

