/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback;

import java.util.Optional;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackCompareInputData;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackMergeViewer;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public final class TextFallbackCompareInputLabelProvider
implements ICompareInputLabelProvider {
    private final EMFCompareConfiguration configuration;
    private final ExtendedAdapterFactoryItemDelegator itemDelegator;
    private final TextFallbackMergeViewer textFallbackMergeViewer;

    public TextFallbackCompareInputLabelProvider(TextFallbackMergeViewer textFallbackMergeViewer, EMFCompareConfiguration configuration) {
        this.textFallbackMergeViewer = textFallbackMergeViewer;
        this.configuration = configuration;
        this.itemDelegator = new ExtendedAdapterFactoryItemDelegator(configuration.getAdapterFactory());
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    private String getLabel(Resource resource, IStorage storage, boolean dirty) {
        Optional<Object> label = Optional.ofNullable(null);
        if (resource != null) {
            label = resource.eAdapters().stream().filter(StoragePathAdapter.class::isInstance).map(adapter -> this.getLabel(storage, dirty, (StoragePathAdapter)adapter)).findFirst();
        }
        return label.orElse("");
    }

    private String getLabel(IStorage storage, boolean dirty, StoragePathAdapter storagePathAdapter) {
        String label = storagePathAdapter.getStoragePath();
        if (storage instanceof IFile) {
            if (this.configuration.getBooleanProperty("SHOW_PREVIEW", true)) {
                label = EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.preview.title", label);
            } else {
                label = EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.local.title", label);
                if (dirty) {
                    label = EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.dirty.title", label);
                }
            }
        }
        return label;
    }

    private boolean isDirty(boolean left) {
        if (left != this.configuration.isMirrored()) {
            return this.textFallbackMergeViewer.isLeftDirty();
        }
        return this.textFallbackMergeViewer.isRightDirty();
    }

    private Image getImage(Resource resource) {
        if (resource != null) {
            Object image = this.itemDelegator.getImage((Object)resource);
            return ExtendedImageRegistry.INSTANCE.getImage(image);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getAncestorLabel(Object input) {
        if (input instanceof TextFallbackCompareInput) {
            TextFallbackCompareInputData textInputData = ((TextFallbackCompareInput)((Object)input)).getTextInputData();
            return this.getLabel(textInputData.getOriginResource(), textInputData.getOriginStorage(), false);
        }
        return null;
    }

    public Image getAncestorImage(Object input) {
        if (input instanceof TextFallbackCompareInput) {
            TextFallbackCompareInputData textInputData = ((TextFallbackCompareInput)((Object)input)).getTextInputData();
            return this.getImage(textInputData.getOriginResource());
        }
        return null;
    }

    public String getLeftLabel(Object input) {
        if (input instanceof TextFallbackCompareInput) {
            TextFallbackCompareInputData textInputData = ((TextFallbackCompareInput)((Object)input)).getTextInputData();
            return this.getLabel(textInputData.getLeftResource(), textInputData.getLeftStorage(), this.isDirty(true));
        }
        return null;
    }

    public Image getLeftImage(Object input) {
        if (input instanceof TextFallbackCompareInput) {
            TextFallbackCompareInputData textInputData = ((TextFallbackCompareInput)((Object)input)).getTextInputData();
            return this.getImage(textInputData.getLeftResource());
        }
        return null;
    }

    public String getRightLabel(Object input) {
        if (input instanceof TextFallbackCompareInput) {
            TextFallbackCompareInputData textInputData = ((TextFallbackCompareInput)((Object)input)).getTextInputData();
            return this.getLabel(textInputData.getRightResource(), textInputData.getRightStorage(), this.isDirty(false));
        }
        return null;
    }

    public Image getRightImage(Object input) {
        if (input instanceof TextFallbackCompareInput) {
            return this.getImage(((TextFallbackCompareInput)((Object)input)).getTextInputData().getRightResource());
        }
        return null;
    }
}

