/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.command.impl.AbstractCopyCommand;
import org.eclipse.emf.compare.command.impl.TransactionalDualCompareCommandStack;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.provider.ITooltipLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeAction
extends BaseSelectionListenerAction {
    private static final com.google.common.base.Predicate<Diff> IS_IN_TERMINAL_STATE = new com.google.common.base.Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return AbstractMerger.isInTerminalState((Diff)diff);
        }
    };
    private static final com.google.common.base.Predicate<Diff> IS_NOT_IN_TERMINAL_STATE = new com.google.common.base.Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return !AbstractMerger.isInTerminalState((Diff)diff);
        }
    };
    protected static final Function<? super Adapter, ? extends Notifier> ADAPTER__TARGET = new Function<Adapter, Notifier>(){

        public Notifier apply(Adapter adapter) {
            return adapter.getTarget();
        }
    };
    protected final IMerger.Registry mergerRegistry;
    protected ICompareEditingDomain editingDomain;
    private final List<Diff> selectedDifferences;
    private final INavigatable navigatable;
    private final MergeMode selectedMode;
    private AdapterFactory adapterFactory;
    private IDiffRelationshipComputer diffRelationshipComputer;
    private IEMFCompareConfiguration compareConfiguration;

    public MergeAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable) {
        super("");
        this.compareConfiguration = compareConfiguration;
        this.adapterFactory = compareConfiguration.getAdapterFactory();
        this.diffRelationshipComputer = compareConfiguration.getDiffRelationshipComputer();
        boolean isLeftEditable = compareConfiguration.isLeftEditable();
        boolean isRightEditable = compareConfiguration.isRightEditable();
        this.navigatable = navigatable;
        Preconditions.checkNotNull((Object)mode);
        Preconditions.checkState((isLeftEditable || isRightEditable ? 1 : 0) != 0);
        if (isLeftEditable && isRightEditable) {
            Preconditions.checkState((mode == MergeMode.LEFT_TO_RIGHT || mode == MergeMode.RIGHT_TO_LEFT ? 1 : 0) != 0);
        }
        if (isLeftEditable != isRightEditable) {
            Preconditions.checkState((mode == MergeMode.ACCEPT || mode == MergeMode.REJECT ? 1 : 0) != 0);
        }
        this.editingDomain = compareConfiguration.getEditingDomain();
        this.mergerRegistry = mergerRegistry;
        this.selectedDifferences = Lists.newArrayList();
        this.selectedMode = mode;
        this.initToolTipAndImage(mode);
    }

    public MergeAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection) {
        this(compareConfiguration, mergerRegistry, mode, navigatable);
        this.setEnabled(this.updateSelection(selection));
    }

    protected IMergeRunnable createMergeRunnable(MergeMode mode, boolean leftEditable, boolean rightEditable, IDiffRelationshipComputer relationshipComputer) {
        return new MergeRunnableImpl(leftEditable, rightEditable, mode, relationshipComputer);
    }

    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.to.right.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.to.left.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setText(EMFCompareIDEUIMessages.getString("accept.change.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.change.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_change.gif"));
                break;
            }
            case REJECT: {
                this.setText(EMFCompareIDEUIMessages.getString("reject.change.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.change.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_change.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void contextualizeTooltip() {
        if (this.selectedDifferences.size() > 1) {
            this.setMultipleTooltip(this.selectedMode);
        } else if (this.selectedDifferences.isEmpty()) {
            this.initToolTipAndImage(this.selectedMode);
        } else {
            Diff diff = this.selectedDifferences.get(0);
            if (diff.getState() == DifferenceState.UNRESOLVED) {
                Adapter adapter = this.adapterFactory.adapt((Notifier)diff, ITooltipLabelProvider.class);
                if (adapter instanceof ITooltipLabelProvider) {
                    String tooltip = ((ITooltipLabelProvider)adapter).getTooltip(this.selectedMode);
                    this.setToolTipText(tooltip);
                } else {
                    this.initToolTipAndImage(this.selectedMode);
                }
            } else {
                this.initToolTipAndImage(this.selectedMode);
            }
        }
    }

    private void setMultipleTooltip(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.multiple.to.right.tooltip"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.multiple.to.left.tooltip"));
                break;
            }
            case ACCEPT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.multiple.changes.tooltip"));
                break;
            }
            case REJECT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.multiple.changes.tooltip"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        mode = this.getSelectedMode();
        commandStack = this.editingDomain.getCommandStack();
        if (commandStack instanceof TransactionalDualCompareCommandStack) {
            transactionalDualCompareCommandStack = (TransactionalDualCompareCommandStack)commandStack;
            oldDeliver = transactionalDualCompareCommandStack.isDeliver();
            try {
                transactionalDualCompareCommandStack.setDeliver(false);
                managedCmdStack = new ManagedCommandStack(commandStack);
                managedCmdStack.undoUntilDiffsAreInTerminalState(this.selectedDifferences);
                if (Iterables.any(this.selectedDifferences, MergeAction.IS_IN_TERMINAL_STATE)) {
                    managedCmdStack.restoreCommandStack();
                    return;
                }
                if (managedCmdStack.hasUnrepeatableCommands() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (String)EMFCompareIDEUIMessages.getString("MergeAction.redoProblem.title"), (String)EMFCompareIDEUIMessages.getString("MergeAction.redoProblem.message", new Object[]{managedCmdStack.getNonRepeatableCommandsCount()}))) {
                    managedCmdStack.restoreCommandStack();
                    return;
                }
                this.execute(commandStack, mode, this.selectedDifferences);
                haveUndoneSelectedDifferences = managedCmdStack.redoExcept(this.selectedDifferences, mode);
                if (!haveUndoneSelectedDifferences) ** GOTO lbl26
                this.execute(commandStack, mode, this.selectedDifferences);
            }
            finally {
                if (oldDeliver) {
                    transactionalDualCompareCommandStack.setDeliver(true);
                }
            }
        } else {
            this.execute(commandStack, mode, this.selectedDifferences);
        }
lbl26:
        // 3 sources

        if (this.navigatable != null && EMFCompareIDEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.emf.compare.ide.ui.preference.selectNextUnresolvedDiff")) {
            this.navigatable.selectChange(80);
        }
    }

    protected void execute(ICompareCommandStack commandStack, MergeMode mode, List<Diff> diffs) {
        IMergeRunnable runnable = this.createMergeRunnable(mode, this.isLeftEditable(), this.isRightEditable(), this.diffRelationshipComputer);
        ICompareCopyCommand command = this.editingDomain.createCopyCommand(diffs, mode.isLeftToRight(this.isLeftEditable(), this.isRightEditable()), this.mergerRegistry, runnable);
        commandStack.execute((Command)command);
    }

    protected void executeCompareCopyCommand(ICompareCommandStack commandStack, MergeMode mode, List<Diff> diffs) {
        MergeRunnableImpl runnable = new MergeRunnableImpl(this.isLeftEditable(), this.isRightEditable(), mode, this.diffRelationshipComputer);
        ICompareCopyCommand command = this.editingDomain.createCopyCommand(diffs, mode.isLeftToRight(this.isLeftEditable(), this.isRightEditable()), this.mergerRegistry, (IMergeRunnable)runnable);
        commandStack.execute((Command)command);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Iterables.addAll(this.selectedDifferences, this.getSelectedDifferences(selection));
        if (this.adapterFactory != null) {
            this.contextualizeTooltip();
        }
        return !this.selectedDifferences.isEmpty() && selection.toList().size() == this.selectedDifferences.size();
    }

    protected void clearCache() {
        this.selectedDifferences.clear();
    }

    protected Iterable<Diff> getSelectedDifferences(IStructuredSelection selection) {
        List selectedObjects = selection.toList();
        Iterable selectedAdapters = Iterables.filter((Iterable)selectedObjects, Adapter.class);
        Iterable selectedNotifiers = Iterables.transform((Iterable)selectedAdapters, ADAPTER__TARGET);
        Iterable selectedTreeNode = Iterables.filter((Iterable)selectedNotifiers, TreeNode.class);
        Iterable selectedEObjects = Iterables.transform((Iterable)selectedTreeNode, (Function)IDifferenceGroup.TREE_NODE_DATA);
        Iterable diffs = Iterables.filter((Iterable)selectedEObjects, Diff.class);
        if (Iterables.isEmpty((Iterable)diffs)) {
            diffs = Iterables.filter((Iterable)selectedObjects, Diff.class);
        }
        return this.getSelectedDifferences(diffs);
    }

    protected com.google.common.base.Predicate<Diff> getStatePredicate() {
        return new com.google.common.base.Predicate<Diff>(){

            public boolean apply(Diff diff) {
                switch (diff.getState()) {
                    case DISCARDED: {
                        switch (MergeAction.this.getSelectedMode()) {
                            case ACCEPT: {
                                return true;
                            }
                            case LEFT_TO_RIGHT: {
                                return diff.getSource() == DifferenceSource.LEFT;
                            }
                            case RIGHT_TO_LEFT: {
                                return diff.getSource() == DifferenceSource.RIGHT;
                            }
                        }
                        return false;
                    }
                    case MERGED: {
                        switch (MergeAction.this.getSelectedMode()) {
                            case REJECT: {
                                return true;
                            }
                            case RIGHT_TO_LEFT: {
                                return diff.getSource() == DifferenceSource.LEFT;
                            }
                            case LEFT_TO_RIGHT: {
                                return diff.getSource() == DifferenceSource.RIGHT;
                            }
                        }
                        return false;
                    }
                }
                return true;
            }
        };
    }

    protected Iterable<Diff> getSelectedDifferences(Iterable<Diff> diffs) {
        ICompareCommandStack commandStack = this.editingDomain.getCommandStack();
        if (!(commandStack instanceof TransactionalDualCompareCommandStack)) {
            return Iterables.filter(diffs, IS_NOT_IN_TERMINAL_STATE);
        }
        return Iterables.filter(diffs, this.getStatePredicate());
    }

    public final void setEditingDomain(ICompareEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.clearCache();
        this.setEnabled(editingDomain != null && this.updateSelection(this.getStructuredSelection()));
    }

    public final void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory != null) {
            this.contextualizeTooltip();
        }
    }

    protected final boolean isLeftToRight() {
        return this.getSelectedMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable());
    }

    public List<Diff> getSelectedDifferences() {
        return this.selectedDifferences;
    }

    protected IDiffRelationshipComputer getDiffRelationshipComputer() {
        return this.diffRelationshipComputer;
    }

    protected MergeMode getSelectedMode() {
        if (this.isMirrored() && (this.selectedMode == MergeMode.LEFT_TO_RIGHT || this.selectedMode == MergeMode.RIGHT_TO_LEFT)) {
            return this.selectedMode.inverse();
        }
        return this.selectedMode;
    }

    protected boolean isLeftEditable() {
        return this.compareConfiguration.isLeftEditable();
    }

    protected boolean isRightEditable() {
        return this.compareConfiguration.isRightEditable();
    }

    protected boolean isMirrored() {
        return this.compareConfiguration.isMirrored();
    }

    private class ManagedCommandStack {
        private List<Multimap<DifferenceState, Diff>> diffChangesList = Lists.newArrayList();
        private Map<Multimap<DifferenceState, Diff>, EMFCompareTextMergeViewer.EditCommand> editCommands = new IdentityHashMap<Multimap<DifferenceState, Diff>, EMFCompareTextMergeViewer.EditCommand>();
        private int nonRepeatableCommandCount = 0;
        private ICompareCommandStack commandStack;
        private boolean isChangeUndoneYet;

        public ManagedCommandStack(ICompareCommandStack commandStack) {
            this.commandStack = commandStack;
        }

        private void addChangedDiffs(Multimap<DifferenceState, Diff> changedDiffs) {
            this.diffChangesList.add(changedDiffs);
        }

        private void addChangedDiffs(Multimap<DifferenceState, Diff> changedDiffs, EMFCompareTextMergeViewer.EditCommand editCommand) {
            this.addChangedDiffs(changedDiffs);
            this.editCommands.put(changedDiffs, editCommand);
        }

        private int getChangedDiffsSize() {
            return this.diffChangesList.size();
        }

        private void reverseDiffChanges() {
            Collections.reverse(this.diffChangesList);
        }

        private List<Multimap<DifferenceState, Diff>> getDiffChanges() {
            return this.diffChangesList;
        }

        private EMFCompareTextMergeViewer.EditCommand getEditCommand(Multimap<DifferenceState, Diff> diffChanges) {
            return this.editCommands.get(diffChanges);
        }

        private void increaseNonRepeatableCommandCount() {
            ++this.nonRepeatableCommandCount;
        }

        public int getNonRepeatableCommandsCount() {
            return this.nonRepeatableCommandCount;
        }

        public int getUndoneCommandsCount() {
            return this.getNonRepeatableCommandsCount() + this.getChangedDiffsSize();
        }

        public boolean hasUnrepeatableCommands() {
            return this.getNonRepeatableCommandsCount() > 0;
        }

        public void undoUntilDiffsAreInTerminalState(List<Diff> diffs) {
            while (this.commandStack.canUndo() && Iterables.any(diffs, (com.google.common.base.Predicate)IS_IN_TERMINAL_STATE)) {
                Command undoCommand = this.commandStack.getUndoCommand();
                if (undoCommand instanceof AbstractCopyCommand) {
                    AbstractCopyCommand copyCommand = (AbstractCopyCommand)undoCommand;
                    this.addChangedDiffs((Multimap<DifferenceState, Diff>)copyCommand.getChangedDiffs());
                } else if (undoCommand instanceof EMFCompareTextMergeViewer.EditCommand) {
                    EMFCompareTextMergeViewer.EditCommand editCommand = (EMFCompareTextMergeViewer.EditCommand)undoCommand;
                    this.addChangedDiffs(editCommand.getChangedDiffs(), editCommand);
                } else if (this.isCompoundCommandContainingAbstractCopyCommand(undoCommand)) {
                    Command firstCommand = this.getFirstCommandFromCompoundCommand(undoCommand);
                    AbstractCopyCommand copyCmd = (AbstractCopyCommand)firstCommand;
                    this.addChangedDiffs((Multimap<DifferenceState, Diff>)copyCmd.getChangedDiffs());
                } else {
                    this.increaseNonRepeatableCommandCount();
                }
                this.commandStack.undo();
            }
        }

        public void restoreCommandStack() {
            int i = this.getUndoneCommandsCount();
            while (i > 0) {
                this.commandStack.redo();
                --i;
            }
        }

        public boolean redoExcept(List<Diff> diffsToExclude, MergeMode mode) {
            this.isChangeUndoneYet = false;
            this.reverseDiffChanges();
            for (Multimap<DifferenceState, Diff> diffsToBeRestored : this.getDiffChanges()) {
                this.redoExcept(diffsToBeRestored, diffsToExclude, mode);
            }
            return this.isChangeUndoneYet;
        }

        private void redoExcept(Multimap<DifferenceState, Diff> diffsToRestore, List<Diff> diffsToExclude, MergeMode mode) {
            EMFCompareTextMergeViewer.EditCommand editCommand = this.getEditCommand(diffsToRestore);
            if (editCommand != null) {
                Collection discardedDiffs = diffsToRestore.get((Object)DifferenceState.DISCARDED);
                for (Diff diff : discardedDiffs) {
                    if (!diffsToExclude.contains(diff)) continue;
                    return;
                }
                this.undoIfNotUndoneYet();
                this.commandStack.execute((Command)editCommand.recreate());
                return;
            }
            this.removeTerminalStateDiffs(diffsToRestore.values().iterator());
            if (!diffsToRestore.values().isEmpty()) {
                this.undoIfNotUndoneYet();
                ArrayList diffsToMerge = Lists.newArrayList((Iterable)diffsToRestore.get((Object)DifferenceState.MERGED));
                ArrayList diffsToDiscard = Lists.newArrayList((Iterable)diffsToRestore.get((Object)DifferenceState.DISCARDED));
                if (mode == MergeMode.ACCEPT || mode == MergeMode.REJECT) {
                    this.redoDiffs(diffsToMerge, diffsToDiscard, MergeMode.ACCEPT, MergeMode.REJECT);
                } else {
                    List<Diff> diffsToBeCopiedLTR = Streams.concat((Stream[])new Stream[]{diffsToMerge.stream().filter(this.fromSource(DifferenceSource.LEFT)), diffsToDiscard.stream().filter(this.fromSource(DifferenceSource.RIGHT))}).collect(Collectors.toList());
                    List<Diff> diffsToBeCopiedRTL = Stream.concat(diffsToMerge.stream().filter(this.fromSource(DifferenceSource.RIGHT)), diffsToDiscard.stream().filter(this.fromSource(DifferenceSource.LEFT))).collect(Collectors.toList());
                    this.redoDiffs(diffsToBeCopiedLTR, diffsToBeCopiedRTL, MergeMode.LEFT_TO_RIGHT, MergeMode.RIGHT_TO_LEFT);
                }
            }
        }

        private void redoDiffs(List<Diff> diffsToMerge, List<Diff> diffsToDiscarded, MergeMode modeForMerged, MergeMode modeForDiscarded) {
            if (!diffsToMerge.isEmpty()) {
                MergeAction.this.executeCompareCopyCommand(this.commandStack, modeForMerged, diffsToMerge);
                this.removeTerminalStateDiffs(diffsToDiscarded.iterator());
            }
            if (!diffsToDiscarded.isEmpty()) {
                MergeAction.this.executeCompareCopyCommand(this.commandStack, modeForDiscarded, diffsToDiscarded);
            }
        }

        private void undoIfNotUndoneYet() {
            if (!this.isChangeUndoneYet) {
                this.commandStack.undo();
                this.isChangeUndoneYet = true;
            }
        }

        private Predicate<? super Diff> fromSource(DifferenceSource source) {
            return diff -> diff.getSource() == source;
        }

        private boolean isCompoundCommandContainingAbstractCopyCommand(Command command) {
            Command firstCommand = this.getFirstCommandFromCompoundCommand(command);
            return firstCommand instanceof AbstractCopyCommand;
        }

        private Command getFirstCommandFromCompoundCommand(Command possiblyCompoundCommand) {
            CompoundCommand compoundCommand;
            Command command = null;
            if (possiblyCompoundCommand instanceof CompoundCommand && !(compoundCommand = (CompoundCommand)possiblyCompoundCommand).getCommandList().isEmpty()) {
                command = (Command)compoundCommand.getCommandList().get(0);
            }
            return command;
        }

        private void removeTerminalStateDiffs(Iterator<Diff> diffs) {
            while (diffs.hasNext()) {
                if (!AbstractMerger.isInTerminalState((Diff)diffs.next())) continue;
                diffs.remove();
            }
        }
    }
}

