/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import org.eclipse.compare.INavigatable;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectDiffAction
extends Action {
    private final INavigatable navigatable;
    private final int changeFlag;
    private IHandlerActivation activatedHandler;

    public SelectDiffAction(INavigatable navigatable, int changeFlag) {
        this.navigatable = navigatable;
        this.changeFlag = changeFlag;
        this.initToolTipAndImage();
    }

    protected void initToolTipAndImage() {
        switch (this.changeFlag) {
            case 2: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("previous.diff.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/prev_diff.gif"));
                this.setActionDefinitionId("org.eclipse.compare.selectPreviousChange");
                break;
            }
            case 1: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("next.diff.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/next_diff.gif"));
                this.setActionDefinitionId("org.eclipse.compare.selectNextChange");
                break;
            }
            case 81: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("previous.unresolved.diff.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/prev_unresolved_diff.png"));
                break;
            }
            case 80: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("next.unresolved.diff.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/next_unresolved_diff.png"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void activateActionHandler() {
        switch (this.changeFlag) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 81: {
                this.activateActionHandler("org.eclipse.emf.compare.ide.ui.selectPreviousUnresolvedDiff");
                break;
            }
            case 80: {
                this.activateActionHandler("org.eclipse.emf.compare.ide.ui.selectNextUnresolvedDiff");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void activateActionHandler(String actionDefinitionID) {
        if (PlatformUI.isWorkbenchRunning()) {
            this.setActionDefinitionId(actionDefinitionID);
            IHandlerService handlerService = this.getHandlerService();
            if (handlerService != null) {
                this.activatedHandler = handlerService.activateHandler(actionDefinitionID, (IHandler)new ActionHandler((IAction)this));
            }
        }
    }

    protected IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getService(IHandlerService.class);
    }

    public void run() {
        this.navigatable.selectChange(this.changeFlag);
    }

    public void dispose() {
        IHandlerService handlerService = this.getHandlerService();
        if (handlerService != null && this.activatedHandler != null) {
            handlerService.deactivateHandler(this.activatedHandler);
        }
    }
}

