/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import java.io.IOException;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.tests.framework.RuntimeTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.Compare;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.TechnicalitiesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=RuntimeTestRunner.class)
public class TechnicalitiesFilterTests {
    @Compare(left="data/predicates/technicalities/directPseudoConflict/left.ecore", right="data/predicates/technicalities/directPseudoConflict/right.ecore", ancestor="data/predicates/technicalities/directPseudoConflict/ancestor.ecore")
    public void testDirectPseudoConflictingDiffFilter(Comparison comparison) throws IOException {
        ThreeWayComparisonGroupProvider.ConflictsGroupImpl group = new ThreeWayComparisonGroupProvider.ConflictsGroupImpl(comparison, "Conflict", (ECrossReferenceAdapter)new TestECrossReferenceAdapter());
        group.buildSubTree();
        Assert.assertEquals((long)1L, (long)group.getChildren().size());
        TreeNode conflictNode = (TreeNode)group.getChildren().get(0);
        Assert.assertEquals((long)1L, (long)conflictNode.getChildren().size());
        TreeNode matchNode = (TreeNode)conflictNode.getChildren().get(0);
        Assert.assertEquals((long)2L, (long)matchNode.getChildren().size());
        TechnicalitiesFilter filter = new TechnicalitiesFilter();
        Predicate selected = filter.getPredicateWhenSelected();
        Predicate unselected = filter.getPredicateWhenUnselected();
        TreeNode diffNode1 = (TreeNode)matchNode.getChildren().get(0);
        Assert.assertTrue((boolean)selected.apply((Object)diffNode1));
        Assert.assertFalse((boolean)unselected.apply((Object)diffNode1));
        TreeNode diffNode2 = (TreeNode)matchNode.getChildren().get(1);
        Assert.assertTrue((boolean)selected.apply((Object)diffNode2));
        Assert.assertFalse((boolean)unselected.apply((Object)diffNode2));
    }

    private class TestECrossReferenceAdapter
    extends ECrossReferenceAdapter {
        private TestECrossReferenceAdapter() {
        }

        protected boolean isIncluded(EReference eReference) {
            return eReference == TreePackage.Literals.TREE_NODE__DATA;
        }
    }
}

