/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view;

import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.ILogicalModelViewHandler;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.LogicalModelViewContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.LogicalModelViewHandlerUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.LogicalModelViewLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressInfoComposite;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressMonitorWrapper;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class LogicalModelView
extends CommonNavigator {
    private Composite container;
    private CommonViewer viewer;
    private LogicalModelViewContentProvider viewContentProvider;
    private JobProgressInfoComposite progressInfoItem;
    private SelectionChangedJob selectionChangedTask;
    private IAction synchronizeAction;
    private Action listPresentationAction;
    private Action treePresentationAction;
    private ListenToSelection listenToSelection;
    private ISelectionService selectionService;
    private IWorkbenchPart lastPart;
    private ISelection lastSelection;
    private boolean synchroActive;
    private Presentation presentation = Presentation.LIST;
    private final IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
    private IPropertyChangeListener preferenceStoreListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (LogicalModelView.this.synchroActive && "org.eclipse.emf.compare.ide.ui.preference.resolutionScope" == event.getProperty() && !event.getOldValue().equals(event.getNewValue())) {
                LogicalModelView.this.selectionChangedTask.schedule();
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.container.setLayout((Layout)layout);
        super.createPartControl(this.container);
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        this.selectionChangedTask = new SelectionChangedJob(EMFCompareIDEUIMessages.getString("LogicalModelView.computingLogicalModel"));
        this.selectionChangedTask.setPriority(30);
        this.progressInfoItem = new JobProgressInfoComposite(this.selectionChangedTask, aParent, 65792, 0);
        this.progressInfoItem.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.progressInfoItem.setBackground(Display.getDefault().getSystemColor(25));
        this.viewer = super.createCommonViewerObject(aParent);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewContentProvider = new LogicalModelViewContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.viewContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LogicalModelViewLabelProvider(this));
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.updateLayout(false, false);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.selectionService = activeWorkbenchWindow.getSelectionService();
        this.makeActions();
        this.fillToolbar();
        return this.viewer;
    }

    public void setFocus() {
        if (this.getCommonViewer().getControl().isVisible()) {
            this.getCommonViewer().getControl().setFocus();
        } else {
            this.progressInfoItem.setFocus();
        }
    }

    public void dispose() {
        if (this.listenToSelection != null) {
            this.selectionService.removePostSelectionListener((ISelectionListener)this.listenToSelection);
        }
        if (!this.selectionChangedTask.cancel()) {
            try {
                this.selectionChangedTask.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Throwables.propagate((Throwable)e);
            }
        }
        super.dispose();
    }

    Presentation getPresentation() {
        return this.presentation;
    }

    private void makeActions() {
        if (this.listenToSelection == null) {
            this.listenToSelection = new ListenToSelection();
        }
        this.selectionService.addPostSelectionListener((ISelectionListener)this.listenToSelection);
        String synchronizationLabel = EMFCompareIDEUIMessages.getString("LogicalModelView.linkWithEditorAndSelection");
        this.synchronizeAction = new Action(synchronizationLabel, 2){

            public void run() {
                if (this.isChecked()) {
                    LogicalModelView.this.synchroActive = true;
                    LogicalModelView.this.store.addPropertyChangeListener(LogicalModelView.this.preferenceStoreListener);
                    LogicalModelView.this.listenToSelection.selectionChanged(LogicalModelView.this.lastPart, LogicalModelView.this.lastSelection);
                } else {
                    LogicalModelView.this.synchroActive = false;
                    LogicalModelView.this.store.removePropertyChangeListener(LogicalModelView.this.preferenceStoreListener);
                }
            }
        };
        this.synchronizeAction.setToolTipText(synchronizationLabel);
        EMFCompareIDEUIPlugin.getDefault();
        this.synchronizeAction.setImageDescriptor(EMFCompareIDEUIPlugin.getImageDescriptor("icons/full/eobj16/synced.gif"));
        this.listPresentationAction = new Action(EMFCompareIDEUIMessages.getString("LogicalModelView.listPresentation.title"), 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                LogicalModelView.this.presentation = Presentation.LIST;
                LogicalModelView.this.treePresentationAction.setChecked(false);
                SWTUtil.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LogicalModelView.this.getCommonViewer().refresh();
                    }
                });
            }
        };
        EMFCompareIDEUIPlugin.getDefault();
        this.listPresentationAction.setImageDescriptor(EMFCompareIDEUIPlugin.getImageDescriptor("icons/full/eobj16/flatLayout.gif"));
        this.treePresentationAction = new Action(EMFCompareIDEUIMessages.getString("LogicalModelView.treePresentation.title"), 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                LogicalModelView.this.presentation = Presentation.TREE;
                LogicalModelView.this.listPresentationAction.setChecked(false);
                SWTUtil.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LogicalModelView.this.getCommonViewer().refresh();
                    }
                });
            }
        };
        EMFCompareIDEUIPlugin.getDefault();
        this.treePresentationAction.setImageDescriptor(EMFCompareIDEUIPlugin.getImageDescriptor("icons/full/eobj16/hierarchicalLayout.gif"));
    }

    private void fillToolbar() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add(this.synchronizeAction);
        IMenuManager dropdownMenu = bars.getMenuManager();
        this.listPresentationAction.setChecked(true);
        dropdownMenu.add((IAction)this.listPresentationAction);
        dropdownMenu.add((IAction)this.treePresentationAction);
    }

    private void updateLayout(boolean displayProgress, boolean doLayout) {
        ((GridData)this.progressInfoItem.getLayoutData()).exclude = !displayProgress;
        this.progressInfoItem.setVisible(displayProgress);
        ((GridData)this.viewer.getControl().getLayoutData()).exclude = displayProgress;
        this.viewer.getControl().setVisible(!displayProgress);
        if (doLayout) {
            this.container.layout(true, true);
        }
    }

    private final class ListenToSelection
    implements ISelectionListener {
        private ListenToSelection() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(part instanceof LogicalModelView)) {
                LogicalModelView.this.lastPart = part;
                LogicalModelView.this.lastSelection = selection;
            }
            if (LogicalModelView.this.synchroActive && selection != null && !selection.isEmpty() && !selection.equals(LogicalModelView.this.selectionChangedTask.getSelection())) {
                LogicalModelView.this.selectionChangedTask.setPart(part);
                LogicalModelView.this.selectionChangedTask.setSelection(selection);
                LogicalModelView.this.selectionChangedTask.schedule();
            }
        }
    }

    public static enum Presentation {
        LIST,
        TREE;

    }

    private final class SelectionChangedJob
    extends Job {
        private IWorkbenchPart part;
        private ISelection selection;

        private SelectionChangedJob(String name) {
            super(name);
        }

        public void setPart(IWorkbenchPart part) {
            this.part = part;
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            JobProgressMonitorWrapper wrapper = new JobProgressMonitorWrapper(monitor, LogicalModelView.this.progressInfoItem);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)wrapper, (int)100);
            ILogicalModelViewHandler handler = EMFCompareIDEUIPlugin.getDefault().getLogicalModelViewHandlerRegistry().getBestHandlerFor(this.part, this.selection);
            if (handler != null) {
                SWTUtil.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!LogicalModelView.this.container.isDisposed()) {
                            LogicalModelView.this.updateLayout(true, true);
                        }
                    }
                });
                Collection<SynchronizationModel> logicalModels = handler.getSynchronizationModels(this.part, this.selection, (IProgressMonitor)subMonitor.newChild(50));
                for (SynchronizationModel logicalModel : logicalModels) {
                    Diagnostic diagnostic = logicalModel.getDiagnostic();
                    if (diagnostic == null || diagnostic.getSeverity() == 0 || status == Status.CANCEL_STATUS) continue;
                    SWTUtil.safeSyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)LogicalModelView.this.getSite().getShell(), (String)EMFCompareIDEUIMessages.getString("LogicalModelView.errorDialog.title"), (String)EMFCompareIDEUIMessages.getString("LogicalModelView.errorDialog.message"));
                        }
                    });
                    status = Status.CANCEL_STATUS;
                }
                final Collection<Object> resources = status == Status.OK_STATUS ? LogicalModelViewHandlerUtil.getLogicalModelResources(logicalModels, (IProgressMonitor)subMonitor.newChild(50)) : Collections.emptySet();
                if (!monitor.isCanceled()) {
                    SWTUtil.safeSyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LogicalModelView.this.updateLayout(false, true);
                            LogicalModelView.this.viewContentProvider.setLeaves(resources);
                            LogicalModelView.this.getCommonViewer().refresh();
                        }
                    });
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
            return status;
        }
    }
}

