/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ResourceComputationSchedulerTest {
    @Rule
    public final Timeout timeout = new Timeout(15L, TimeUnit.SECONDS);
    protected ResourceComputationScheduler<String> scheduler;
    protected boolean flag;

    @Test
    public void testInitializeCanBeCalledSeveralTimes() {
        this.scheduler.initialize();
        this.scheduler.initialize();
    }

    @Test
    public void testIsInitializedBeforeInit() {
        Assert.assertFalse((boolean)this.scheduler.isInitialized());
    }

    @Test
    public void testIsInitializedAfterInit() {
        this.scheduler.initialize();
        Assert.assertTrue((boolean)this.scheduler.isInitialized());
    }

    @Test
    public void testIsInitializedAfterDispose() {
        this.scheduler.initialize();
        this.scheduler.dispose();
        Assert.assertFalse((boolean)this.scheduler.isInitialized());
    }

    @Test
    public void testBasicExecution() throws Exception {
        this.scheduler.initialize();
        this.flag = false;
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 42;
            }
        }, new Runnable(){

            @Override
            public void run() {
                ResourceComputationSchedulerTest.this.flag = true;
            }
        });
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.flag);
    }

    @Test(expected=OperationCanceledException.class)
    public void testInterruptedExceptionInCallCausesOperationCanceledException() throws Exception {
        this.scheduler.initialize();
        this.scheduler.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw new InterruptedException();
            }
        }, null);
    }

    @Test(expected=OperationCanceledException.class)
    public void testOperationCanceledExceptionCall() throws Exception {
        this.scheduler.initialize();
        this.scheduler.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw new OperationCanceledException();
            }
        }, null);
    }

    @Test
    public void testPostTreatmentIsCalledWhenExceptionInTreatment() throws Exception {
        this.scheduler.initialize();
        this.flag = false;
        try {
            this.scheduler.call((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    throw new Exception("For test");
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ResourceComputationSchedulerTest.this.flag = true;
                }
            });
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"For test", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.flag);
    }

    @Test
    public void testPostTreatmentCanBeNull() throws Exception {
        this.scheduler.initialize();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 42;
            }
        }, null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testCallableCannotBeNull() throws Exception {
        this.scheduler.initialize();
        this.scheduler.call(null, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Test
    public void testComputedElements() {
        this.scheduler.initialize();
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
        this.scheduler.setComputedElements(Arrays.asList("a", "b", "c"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"), (Object)this.scheduler.getComputedElements());
        this.scheduler.clearComputedElements();
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testComputeOneSuccess() throws Exception {
        this.scheduler.initialize();
        final CompStatus desc = new CompStatus();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll(Arrays.asList(new TestSuccessfulComputation(desc, "comp1")));
                Assert.assertEquals((Object)ImmutableSet.of((Object)"comp1"), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        this.checkSuccess(desc);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testComputeSeveralSuccess() throws Exception {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList computations = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            statuses[i] = new CompStatus();
            computations.add(new TestSuccessfulComputation(statuses[i], "comp" + i));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int i = 0;
                while (i < 10) {
                    ResourceComputationSchedulerTest.this.scheduler.computeAll((Iterable)computations);
                    ++i;
                }
                Assert.assertEquals((Object)ImmutableSet.of((Object)"comp0", (Object)"comp1", (Object)"comp2", (Object)"comp3", (Object)"comp4", (Object)"comp5", (Object[])new String[]{"comp6", "comp7", "comp8", "comp9"}), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkSuccess(statuses[i2]);
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testPostTreatmentOnFailureIsCalledOnOneFailedComputation() throws Exception {
        this.scheduler.initialize();
        final CompStatus cs = new CompStatus();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll(Arrays.asList(new TestFailedComputation(cs, "fail1")));
                Assert.assertEquals((Object)ImmutableSet.of((Object)"fail1"), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        this.checkFailure(cs);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testPostTreatmentOnFailureIsCalledOnAllFailingComputations() throws Exception {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList computations = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            statuses[i] = new CompStatus();
            computations.add(new TestFailedComputation(statuses[i], "fail" + i));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll((Iterable)computations);
                Assert.assertEquals((Object)ImmutableSet.of((Object)"fail0", (Object)"fail1", (Object)"fail2", (Object)"fail3", (Object)"fail4", (Object)"fail5", (Object[])new String[]{"fail6", "fail7", "fail8", "fail9"}), (Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements());
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkFailure(statuses[i2]);
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testRunOneSuccess() throws Exception {
        this.scheduler.initialize();
        final CompStatus desc = new CompStatus();
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.runAll(Arrays.asList(new UninterruptibleRunnable(desc)));
                Assert.assertTrue((boolean)ResourceComputationSchedulerTest.this.scheduler.getComputedElements().isEmpty());
                return 42;
            }
        }, null);
        this.checkSuccess(desc);
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testRunSeveralSuccess() throws Exception {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList toBeRun = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            statuses[i] = new CompStatus();
            toBeRun.add(new UninterruptibleRunnable(statuses[i]));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.runAll((Iterable)toBeRun);
                Assert.assertTrue((boolean)ResourceComputationSchedulerTest.this.scheduler.getComputedElements().isEmpty());
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkSuccess(statuses[i2]);
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testScheduleComputationCannotRunOutsideCall() throws Exception {
        this.scheduler.initialize();
        CompStatus desc = new CompStatus();
        this.scheduler.scheduleComputation((IComputation)new TestSuccessfulComputation(desc, "comp"));
    }

    @Test
    public void testAllThreadsNotifiedOfCompletion() {
        this.scheduler.initialize();
        CompStatus[][] statuses = new CompStatus[10][10];
        final ArrayList toBeRun = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            final String key = Character.toString((char)(65 + i));
            final CompStatus[] nestedStatuses = statuses[i];
            toBeRun.add(new Runnable(){

                @Override
                public void run() {
                    ArrayList nested = Lists.newArrayList();
                    int j = 0;
                    while (j < 10) {
                        CompStatus status;
                        final String nestedKey = String.valueOf(key) + j;
                        nestedStatuses[j] = status = new CompStatus();
                        nested.add(new IComputation<String>(){

                            public String getKey() {
                                return nestedKey;
                            }

                            public void run() {
                                status.addCall();
                                status.success("as expected");
                            }

                            public FutureCallback<Object> getPostTreatment() {
                                return null;
                            }
                        });
                        ++j;
                    }
                    ResourceComputationSchedulerTest.this.scheduler.computeAll((Iterable)nested);
                    Object[] expectedKeys = (String[])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9"), (Function)new Function<String, String>(){

                        public String apply(String input) {
                            return String.valueOf(key) + input;
                        }
                    }), String.class);
                    MatcherAssert.assertThat((Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements(), (Matcher)Matchers.hasItems((Object[])expectedKeys));
                }
            });
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ExecutorService exec = Executors.newFixedThreadPool(4);
                try {
                    for (Runnable next : toBeRun) {
                        exec.execute(next);
                    }
                    exec.shutdown();
                    exec.awaitTermination(15L, TimeUnit.SECONDS);
                    ImmutableSet expectedKeys = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Lists.cartesianProduct((List[])new List[]{Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J"), Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9")}), (Function)new Function<List<String>, String>(){

                        public String apply(List<String> input) {
                            return String.valueOf(input.get(0)) + input.get(1);
                        }
                    }));
                    MatcherAssert.assertThat((Object)ResourceComputationSchedulerTest.this.scheduler.getComputedElements(), (Matcher)Matchers.is((Object)expectedKeys));
                }
                finally {
                    exec.shutdown();
                }
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            int j = 0;
            while (j < 10) {
                this.checkSuccess(statuses[i2][j]);
                ++j;
            }
            ++i2;
        }
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertTrue((boolean)this.scheduler.getComputedElements().isEmpty());
    }

    @Test
    public void testIsScheduled() {
        this.testTemplate_concurrentAccessToComputedElements(new Function<String, Callable<String>>(){

            public Callable<String> apply(final String key) {
                return new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        Thread.sleep(250L);
                        MatcherAssert.assertThat((Object)(this).ResourceComputationSchedulerTest.this.scheduler.isScheduled((Object)key), (Matcher)Matchers.is((Object)true));
                        Thread.sleep(250L);
                        return key;
                    }
                };
            }
        });
    }

    private void testTemplate_concurrentAccessToComputedElements(Function<String, Callable<String>> bodyFactory) {
        this.scheduler.initialize();
        CompStatus[] statuses = new CompStatus[10];
        final ArrayList toBeComputed = Lists.newArrayList();
        int i = 0;
        while (i < 10) {
            CompStatus status;
            String key = Character.toString((char)(65 + i));
            statuses[i] = status = new CompStatus();
            toBeComputed.add(new TestComputation(status, key, (Callable)bodyFactory.apply((Object)key), null, null));
            ++i;
        }
        Integer result = (Integer)this.scheduler.call((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ResourceComputationSchedulerTest.this.scheduler.computeAll((Iterable)toBeComputed);
                return 42;
            }
        }, null);
        int i2 = 0;
        while (i2 < 10) {
            this.checkSuccess(statuses[i2]);
            ++i2;
        }
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)42));
        MatcherAssert.assertThat((Object)this.scheduler.getComputedElements(), (Matcher)Matchers.empty());
    }

    @Test
    public void testGetComputedElements() {
        this.testTemplate_concurrentAccessToComputedElements(new Function<String, Callable<String>>(){

            public Callable<String> apply(final String key) {
                return new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        Thread.sleep(250L);
                        MatcherAssert.assertThat((Object)(this).ResourceComputationSchedulerTest.this.scheduler.getComputedElements(), (Matcher)Matchers.hasItem((Object)key));
                        Thread.sleep(250L);
                        return key;
                    }
                };
            }
        });
    }

    @Test
    public void testFailureInRunnable() throws Exception {
        this.scheduler.initialize();
        final CompStatus[] statuses = new CompStatus[10];
        int i = 0;
        while (i < 10) {
            CompStatus status;
            statuses[i] = status = new CompStatus();
            ++i;
        }
        FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    final ArrayList toBeRun = Lists.newArrayList();
                    int i = 0;
                    while (i < 10) {
                        class MaybeThrow
                        implements Runnable {
                            private final CompStatus status;
                            private final boolean doThrow;

                            MaybeThrow(CompStatus status, boolean doThrow) {
                                this.status = status;
                                this.doThrow = doThrow;
                            }

                            @Override
                            public void run() {
                                if (this.doThrow) {
                                    this.status.fail("throwing");
                                    throw new RuntimeException("as expected");
                                }
                                this.status.addCall();
                                this.status.success("as expected");
                            }
                        }
                        toBeRun.add(new MaybeThrow(statuses[i], true));
                        ++i;
                    }
                    Integer result = (Integer)ResourceComputationSchedulerTest.this.scheduler.call((Callable)new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            (this).ResourceComputationSchedulerTest.this.scheduler.runAll((Iterable)toBeRun);
                            return 42;
                        }
                    }, null);
                    Assert.fail((String)"scheduler.call(...) should have thrown");
                    return result;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        });
        new Thread(task).start();
        task.get();
        task = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                return (Integer)ResourceComputationSchedulerTest.this.scheduler.call((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        ArrayList toBeRun = Lists.newArrayList();
                        int i = 0;
                        while (i < 10) {
                            toBeRun.add(new MaybeThrow(statuses[i], false));
                            ++i;
                        }
                        (this).ResourceComputationSchedulerTest.this.scheduler.runAll((Iterable)toBeRun);
                        return 42;
                    }
                }, null);
            }
        });
        new Thread(task).start();
        Integer result = (Integer)task.get();
        int i2 = 0;
        while (i2 < 10) {
            this.checkSuccess(statuses[i2]);
            ++i2;
        }
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)42));
        MatcherAssert.assertThat((Object)this.scheduler.getComputedElements(), (Matcher)Matchers.empty());
    }

    protected void checkSuccess(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertFalse((boolean)state.isInterrupted());
        if (!state.isSuccess() || state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    protected void checkFailure(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertFalse((boolean)state.isInterrupted());
        if (state.isSuccess() || !state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    protected void checkInterruptedAndSuccess(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertTrue((boolean)state.isInterrupted());
        if (!state.isSuccess() || state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    protected void checkInterruptedAndFailure(CompStatus state) {
        Assert.assertEquals((long)1L, (long)state.getCallCount());
        Assert.assertTrue((boolean)state.isInterrupted());
        if (state.isSuccess() || !state.isFailed()) {
            Assert.fail((String)state.getMessage());
        }
        Assert.assertEquals((Object)"as expected", (Object)state.getMessage());
    }

    @Before
    public void setUp() {
        this.scheduler = new ResourceComputationScheduler(100, TimeUnit.MILLISECONDS, null);
    }

    @After
    public void tearDown() {
        this.scheduler.dispose();
    }

    protected static class CompStatus {
        private boolean success = false;
        private boolean failed = false;
        private int callCount;
        private boolean interrupted;
        private ResourceComputationScheduler.ShutdownStatus shutdownStatus;
        private String message;

        protected CompStatus() {
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public synchronized void addCall() {
            ++this.callCount;
        }

        public int getCallCount() {
            return this.callCount;
        }

        public void success(String msg) {
            this.success = true;
            this.failed = false;
            this.message = msg;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void fail(String msg) {
            this.failed = true;
            this.success = false;
            this.message = msg;
        }

        public void interrupt() {
            this.interrupted = true;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void setShutdownStatus(ResourceComputationScheduler.ShutdownStatus shutdownStatus) {
            this.shutdownStatus = shutdownStatus;
        }

        public ResourceComputationScheduler.ShutdownStatus getShutdownStatus() {
            return this.shutdownStatus;
        }
    }

    private class TestComputation<T>
    implements IComputation<String>,
    Supplier<T> {
        private final Callable<? extends T> body;
        private final CompStatus cs;
        private final String name;
        private T result;

        private TestComputation(CompStatus cs, String name, Callable<? extends T> body) {
            this.cs = cs;
            this.name = name;
            this.body = body;
        }

        public synchronized T get() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.cs.addCall();
            try {
                TestComputation testComputation = this;
                synchronized (testComputation) {
                    this.result = this.body.call();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.cs.interrupt();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }

        public FutureCallback<Object> getPostTreatment() {
            return new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    Throwable toReport = t;
                    if (t instanceof WrappedException) {
                        toReport = ((WrappedException)t).exception();
                    }
                    TestComputation.this.fail(String.format("%s: %s", toReport.getClass().getName(), toReport.getMessage()));
                }

                public void onSuccess(Object r) {
                    TestComputation.this.success("as expected");
                }
            };
        }

        public String getKey() {
            return this.name;
        }

        void fail(String message) {
            this.cs.fail(message);
        }

        void success(String message) {
            this.cs.success(message);
        }

        /* synthetic */ TestComputation(CompStatus compStatus, String string, Callable callable, TestComputation testComputation, TestComputation testComputation2) {
            this(compStatus, string, callable);
        }
    }

    private final class TestFailedComputation
    extends TestComputation<String> {
        private TestFailedComputation(CompStatus desc, final String name) {
            super(desc, name, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    throw new RuntimeException("Error for tests in computation " + name);
                }
            });
        }

        @Override
        public FutureCallback<Object> getPostTreatment() {
            return new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    TestFailedComputation.this.fail("as expected");
                }

                public void onSuccess(Object r) {
                    TestFailedComputation.this.success("onSuccess() called on computation " + TestFailedComputation.this.getKey() + ", should have been onFailure().");
                }
            };
        }
    }

    private final class TestSuccessfulComputation
    extends TestComputation<String> {
        private TestSuccessfulComputation(CompStatus cs, final String name) {
            super(cs, name, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Thread.sleep(1L);
                    return name;
                }
            });
        }

        @Override
        public FutureCallback<Object> getPostTreatment() {
            return new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                    TestSuccessfulComputation.this.fail("onFailure() called on computation " + TestSuccessfulComputation.this.getKey() + ", should have been onSuccess().");
                }

                public void onSuccess(Object r) {
                    TestSuccessfulComputation.this.success("as expected");
                }
            };
        }
    }

    private final class UninterruptibleRunnable
    implements Runnable {
        private final CompStatus cs;

        private UninterruptibleRunnable(CompStatus desc) {
            this.cs = desc;
        }

        @Override
        public void run() {
            this.cs.addCall();
            this.cs.success("as expected");
        }
    }
}

