/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class FeatureMapsPseudoConflictsMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void testConflictContainmentPseudoConflictAdd_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictAddScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictAdd_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictAddScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictAdd_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictAddScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictAdd_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictAddScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictAddScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictDelete_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictDelete_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictDelete_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictDelete_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictKeyChange_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictKeyChange_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictKeyChange_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictKeyChange_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictKeyChangeScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMoveOrder_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMoveOrder_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMoveOrder_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMoveOrder_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMove_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMove_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMove_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentPseudoConflictMove_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftPseudoConflictMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightPseudoConflictMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginPseudoConflictMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictAdd_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictAdd_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictAdd_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictAdd_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictAddScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictDelete_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictDelete_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictDelete_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictDelete_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictDeleteScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictMoveOrder_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictMoveOrder_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictMoveOrder_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentPseudoConflictMoveOrder_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightPseudoConflictMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginPseudoConflictMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertEquals((long)2L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

