/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Call;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Expression;
import org.eclipse.acceleo.compatibility.model.mt.expressions.ExpressionsFactory;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ExpressionParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

public final class CallParser {
    private CallParser() {
    }

    public static Call createCall(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        Call call;
        Region localRange = range;
        Region trim = TextSearch.trim(buffer, localRange.b(), localRange.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingElement"), template, localRange);
        }
        localRange = trim;
        Expression filter = null;
        Region begin = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getBrackets()[0], localRange, TemplateConstants.getDefault().getSpec(), new String[][]{TemplateConstants.getDefault().getLiteral(), TemplateConstants.getDefault().getParenth()});
        if (begin.b() > -1) {
            Region end = TextSearch.blockIndexEndIn(buffer, TemplateConstants.getDefault().getBrackets()[0], TemplateConstants.getDefault().getBrackets()[1], new Region(begin.b(), localRange.e()), false, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsExpression());
            if (end.b() == -1) {
                throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingCloseBracket"), template, begin.b());
            }
            if (buffer.substring(end.e(), localRange.e()).trim().length() > 0) {
                throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.InvalidSequence"), template, end.e());
            }
            Region pos = new Region(begin.e(), end.b());
            filter = ExpressionParser.createExpression(offset, buffer, pos, template);
            filter.setBegin(offset + pos.b());
            filter.setEnd(offset + pos.e());
            localRange = new Region(localRange.b(), begin.b());
            trim = TextSearch.trim(buffer, localRange.b(), localRange.e());
            if (trim.b() == -1) {
                throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingElement"), template, localRange);
            }
            localRange = trim;
        }
        if ((begin = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getParenth()[0], localRange, TemplateConstants.getDefault().getSpec(), new String[][]{TemplateConstants.getDefault().getLiteral()})).b() > -1) {
            Region end = TextSearch.blockIndexEndIn(buffer, TemplateConstants.getDefault().getParenth()[0], TemplateConstants.getDefault().getParenth()[1], new Region(begin.b(), localRange.e()), false, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsExpression());
            if (end.b() == -1) {
                throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingCloseParenthesis"), template, begin.b());
            }
            if (buffer.substring(end.e(), localRange.e()).trim().length() > 0) {
                throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.InvalidSequence"), template, end.e());
            }
            Region[] positions = TextSearch.splitPositionsIn(buffer, new Region(begin.e(), end.b()), new String[]{TemplateConstants.getDefault().getArgSep()}, false, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsExpression());
            call = CallParser.newCall(buffer.substring(localRange.b(), begin.b()));
            call.setBegin(offset + localRange.b());
            call.setEnd(offset + localRange.e());
            int i = 0;
            while (i < positions.length) {
                Region pos = positions[i];
                call.getArguments().add((Object)ExpressionParser.createExpression(offset, buffer, pos, template));
                ++i;
            }
        } else {
            call = CallParser.newCall(buffer.substring(localRange.b(), localRange.e()));
            call.setBegin(offset + localRange.b());
            call.setEnd(offset + localRange.e());
        }
        call.setBegin(offset + localRange.b());
        call.setEnd(offset + localRange.e());
        if (filter != null) {
            call.setFilter(filter);
        }
        return call;
    }

    private static Call newCall(String link) {
        Call call = ExpressionsFactory.eINSTANCE.createCall();
        if (link != null) {
            int iDot = link.indexOf(TemplateConstants.getDefault().getLinkPrefixSeparator());
            if (iDot > -1) {
                call.setPrefix(link.substring(0, iDot).trim());
                call.setName(link.substring(iDot + TemplateConstants.getDefault().getLinkPrefixSeparator().length()).trim());
            } else {
                call.setPrefix("");
                call.setName(link.trim());
            }
        } else {
            call.setPrefix("");
            call.setName("");
        }
        return call;
    }
}

