/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.Node;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.TypedNode;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.AnnotableNode;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.FieldDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.MethodDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AnnotationExpr;

public final class PositionUtils {
    private PositionUtils() {
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes, final boolean ignoringAnnotations) {
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return PositionUtils.compare(o1, o2, ignoringAnnotations);
            }
        });
    }

    public static boolean areInOrder(Node a, Node b) {
        return PositionUtils.areInOrder(a, b, false);
    }

    public static boolean areInOrder(Node a, Node b, boolean ignoringAnnotations) {
        return PositionUtils.compare(a, b, ignoringAnnotations) <= 0;
    }

    private static int compare(Node a, Node b, boolean ignoringAnnotations) {
        if (ignoringAnnotations) {
            int signLine = Integer.signum(PositionUtils.beginLineWithoutConsideringAnnotation(a) - PositionUtils.beginLineWithoutConsideringAnnotation(b));
            if (signLine == 0) {
                return Integer.signum(PositionUtils.beginColumnWithoutConsideringAnnotation(a) - PositionUtils.beginColumnWithoutConsideringAnnotation(b));
            }
            return signLine;
        }
        int signLine = Integer.signum(a.getBeginLine() - b.getBeginLine());
        if (signLine == 0) {
            return Integer.signum(a.getBeginColumn() - b.getBeginColumn());
        }
        return signLine;
    }

    public static AnnotationExpr getLastAnnotation(Node node) {
        if (node instanceof AnnotableNode) {
            LinkedList<AnnotationExpr> annotations = new LinkedList<AnnotationExpr>();
            annotations.addAll(((AnnotableNode)((Object)node)).getAnnotations());
            if (annotations.isEmpty()) {
                return null;
            }
            PositionUtils.sortByBeginPosition(annotations);
            return (AnnotationExpr)annotations.get(annotations.size() - 1);
        }
        return null;
    }

    private static int beginLineWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations(node).getBeginLine();
    }

    private static int beginColumnWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations(node).getBeginColumn();
    }

    private static Node beginNodeWithoutConsideringAnnotations(Node node) {
        if (node instanceof MethodDeclaration || node instanceof FieldDeclaration) {
            TypedNode casted = (TypedNode)((Object)node);
            return casted.getType();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration casted = (ClassOrInterfaceDeclaration)node;
            return casted.getNameExpr();
        }
        return node;
    }

    public static boolean nodeContains(Node container, Node contained, boolean ignoringAnnotations) {
        if (!ignoringAnnotations || PositionUtils.getLastAnnotation(container) == null) {
            return container.contains(contained);
        }
        if (!container.contains(contained)) {
            return false;
        }
        if (container instanceof AnnotableNode) {
            int bl = PositionUtils.beginLineWithoutConsideringAnnotation(container);
            int bc = PositionUtils.beginColumnWithoutConsideringAnnotation(container);
            if (bl > contained.getBeginLine()) {
                return false;
            }
            if (bl == contained.getBeginLine() && bc > contained.getBeginColumn()) {
                return false;
            }
            if (container.getEndLine() < contained.getEndLine()) {
                return false;
            }
            return container.getEndLine() != contained.getEndLine() || container.getEndColumn() >= contained.getEndColumn();
        }
        return true;
    }
}

