/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.TopLayerOperatorImpl;

public class CustomTopLayerOperatorImpl
extends TopLayerOperatorImpl {
    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(View view, Property property) throws LayersException {
        for (LayerExpression layer : this.getLayers()) {
            ComputePropertyValueCommand cmd = layer.getComputePropertyValueCommand(view, property);
            if (cmd == null) continue;
            return cmd;
        }
        return null;
    }

    @Override
    public List<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, List<Property> properties) throws LayersException {
        ArrayList<ComputePropertyValueCommand> resCmds = new ArrayList<ComputePropertyValueCommand>(properties.size());
        boolean isCmdFound = false;
        for (Property property : properties) {
            if (property == null) {
                resCmds.add(null);
                continue;
            }
            ComputePropertyValueCommand cmd = this.getComputePropertyValueCommand(view, property);
            if (cmd != null) {
                isCmdFound = true;
            }
            resCmds.add(cmd);
        }
        if (isCmdFound) {
            return resCmds;
        }
        return null;
    }

    @Override
    public List<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(List<View> views, Property property) throws LayersException {
        ArrayList<ComputePropertyValueCommand> resCmds = new ArrayList<ComputePropertyValueCommand>(views.size());
        boolean isCmdFound = false;
        for (View view : views) {
            if (view == null) {
                resCmds.add(null);
                continue;
            }
            ComputePropertyValueCommand cmd = this.getComputePropertyValueCommand(view, property);
            if (cmd != null) {
                isCmdFound = true;
            }
            resCmds.add(cmd);
        }
        if (isCmdFound) {
            return resCmds;
        }
        return null;
    }

    @Override
    public void addLayer(LayerExpression layer) {
        this.getLayers().add(0, layer);
    }

    @Override
    public void setIsBranchEnabled(boolean newIsBranchEnabled) {
        super.setIsBranchEnabled(newIsBranchEnabled);
        boolean value = this.isBranchEnabled();
        for (LayerExpression layer : this.getLayers()) {
            layer.setIsBranchEnabled(value);
        }
    }

    @Override
    public void setOwningLayersStack(LayersStack newOwningLayersStack) {
        super.setOwningLayersStack(newOwningLayersStack);
        LayersStack value = this.getOwningLayersStack();
        for (LayerExpression layer : this.getLayers()) {
            layer.setOwningLayersStack(value);
        }
    }

    @Override
    public void attach() throws LayersException {
        super.attach();
        for (LayerExpression l : this.getLayers()) {
            l.attach();
        }
    }

    @Override
    public void detach() throws LayersException {
        super.detach();
        for (LayerExpression l : this.getLayers()) {
            l.detach();
        }
    }

    @Override
    public boolean isDescriptorSet() {
        return this.getLayerOperatorDescriptor() != null;
    }

    @Override
    public void resetDescriptor() {
        if (this.getApplication() == null || this.getLayerOperatorDescriptorName() == null) {
            return;
        }
        try {
            LayerOperatorDescriptor descriptor = this.getApplication().getLayerOperatorDescriptorRegistry().getLayerOperatorDescriptor(this.getLayerOperatorDescriptorName());
            this.setLayerOperatorDescriptor(descriptor);
        }
        catch (NotFoundException e) {
            Activator.log.error(String.valueOf(this.getClass().getName()) + "- Can't get LayerOperatorDescriptor for descriptorName '" + this.getLayerOperatorDescriptorName() + "'.", (Throwable)e);
        }
    }

    @Override
    public boolean isLayerEnabledInternal() {
        return this.isLayerEnabled && this.isDescriptorSet();
    }

    @Override
    @Deprecated
    public void attachToLayersStack(LayersStack owningLayersStack) {
        this.setOwningLayersStack(owningLayersStack);
        for (LayerExpression l : this.getLayers()) {
            l.attachToLayersStack(owningLayersStack);
        }
        this.startBehaviors();
    }
}

