/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.commands;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddCSSStyleSheetCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.RemoveCSSStyleSheetCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHideInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;

public class HideLayerElementsCommand
extends RecordingCommand {
    private AbstractLayer layer;
    private TransactionalEditingDomain ted;
    private StyleSheet cssToHide;
    private StyleSheet css;
    private CSSDiagram cssDiagram;
    private boolean isAppliedCSS;

    public HideLayerElementsCommand(TransactionalEditingDomain ted, AbstractLayer layer, String label) {
        super(ted, label);
        this.layer = layer;
        this.ted = ted;
        try {
            TypeInstance cssInstance;
            Diagram diagram = layer.getLayersStack().getDiagram();
            if (diagram instanceof CSSDiagram) {
                this.cssDiagram = (CSSDiagram)diagram;
            }
            ArrayList<String> layerPropertiesName = new ArrayList<String>();
            for (Property layerProperty : layer.getAttachedProperties()) {
                layerPropertiesName.add(layerProperty.getName());
            }
            TypeInstance cssHideInstance = layerPropertiesName.contains("cssHide") ? layer.getPropertyInstance("cssHide") : null;
            TypeInstance typeInstance = cssInstance = layerPropertiesName.contains("css") ? layer.getPropertyInstance("css") : null;
            if (cssHideInstance == null && cssInstance != null) {
                this.cssToHide = ((CSSInstance)cssInstance).getStylesheet();
            } else if (cssHideInstance != null) {
                this.cssToHide = ((CSSHideInstance)cssHideInstance).getStylesheet();
            }
        }
        catch (LayersException e) {
            Activator.log.error("There should be a CSS dedicated to hide the layer views", (Throwable)e);
        }
        if (this.cssToHide == null) {
            return;
        }
        String sheetPath = ((StyleSheetReference)this.cssToHide).getPath();
        for (StyleSheet ss : this.cssDiagram.getStyleSheets()) {
            String ssPath = ((StyleSheetReference)ss).getPath();
            if (!sheetPath.equals(ssPath)) continue;
            this.isAppliedCSS = true;
            this.cssToHide = ss;
            break;
        }
    }

    protected void doExecute() {
        if (!this.layer.isLayerEnabled() && !this.isAppliedCSS && this.cssToHide != null) {
            AddCSSStyleSheetCommand acssc = new AddCSSStyleSheetCommand((EditingDomain)this.ted, (View)this.cssDiagram, "css_stylesheets", NotationPackage.eINSTANCE.getEObjectListValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getEObjectListValueStyle_EObjectListValue(), (Object)this.cssToHide);
            acssc.execute();
        }
        if (this.layer.isLayerEnabled() && this.isAppliedCSS && this.cssToHide != null) {
            RemoveCSSStyleSheetCommand rcssc = new RemoveCSSStyleSheetCommand((EditingDomain)this.ted, (View)this.cssDiagram, "css_stylesheets", NotationPackage.eINSTANCE.getEObjectListValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getEObjectListValueStyle_EObjectListValue(), (Object)this.cssToHide);
            rcssc.execute();
        }
    }
}

