/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.NotationDiagramHelper;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelResource;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractLayersCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Object> selections;
        IEvaluationContext context;
        try {
            context = this.getIEvaluationContext(event);
            selections = this.getSelections(context);
        }
        catch (org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException e) {
            return null;
        }
        if (!this.preExecute(event, context, selections)) {
            return null;
        }
        this.executeTransaction(event, context, selections);
        this.postExecute(event, context, selections);
        return null;
    }

    protected boolean preExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) throws ExecutionException {
        return true;
    }

    protected void postExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) throws ExecutionException {
    }

    private void executeTransaction(ExecutionEvent event, final IEvaluationContext context, final List<Object> selections) {
        TransactionalEditingDomain editingDomain;
        final ExecutionEvent finalEvent = event;
        try {
            editingDomain = this.lookupTransactionalEditingDomain(context);
        }
        catch (ServiceException e) {
            return;
        }
        RecordingCommand cmd = new RecordingCommand(editingDomain, this.getCommandName()){

            protected void doExecute() {
                AbstractLayersCommand.this.doExecute(finalEvent, context, selections);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected List<Object> getSelections(IEvaluationContext context) {
        Object sel = context.getVariable("selection");
        if (!(sel instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)sel;
        return structuredSelection.toList();
    }

    public abstract String getCommandName();

    protected abstract void doExecute(ExecutionEvent var1, IEvaluationContext var2, List<Object> var3);

    protected IEvaluationContext getIEvaluationContext(ExecutionEvent event) throws org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException {
        try {
            return (IEvaluationContext)event.getApplicationContext();
        }
        catch (ClassCastException e) {
            throw new org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException("IEvaluationContext can't be found.");
        }
    }

    protected TransactionalEditingDomain lookupTransactionalEditingDomain(IEvaluationContext context) throws ServiceException {
        return ServiceUtilsForIEvaluationContext.getInstance().getTransactionalEditingDomain((Object)context);
    }

    public void setEnabled(Object evaluationContext) {
        if (!(evaluationContext instanceof IEvaluationContext)) {
            this.setBaseEnabled(false);
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        List<Object> selections = this.getSelections(context);
        this.setBaseEnabled(this.isEnabled(context, selections));
    }

    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return true;
    }

    protected NotationDiagramHelper lookupNotationDiagramHelperChecked(IEvaluationContext context) throws org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException, ServiceException {
        IEditorPart editor = ((ISashWindowsContainer)ServiceUtilsForIEvaluationContext.getInstance().getService(ISashWindowsContainer.class, (Object)context)).getActiveEditor();
        if (!(editor instanceof DiagramDocumentEditor)) {
            throw new org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException("Selected editor do not contains Diagram");
        }
        DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            throw new org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException("Selected editor do not contains Diagram");
        }
        LayersModelResource layersModel = (LayersModelResource)ServiceUtilsForIEvaluationContext.getInstance().getModelSet((Object)context).getModel("org.eclipse.papyrus.layers.resource.LayersModel");
        return new NotationDiagramHelper(layersModel, diagram);
    }

    protected LayersStackApplication lookupLayersStackApplicationChecked(IEvaluationContext context) throws org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException, ServiceException, NotFoundException {
        ModelSet modelSet = ServiceUtilsForIEvaluationContext.getInstance().getModelSet((Object)context);
        LayersModelResource model = (LayersModelResource)modelSet.getModelChecked("org.eclipse.papyrus.layers.resource.LayersModel");
        return model.lookupLayerStackApplication();
    }

    protected Diagram lookupNotationDiagramChecked(IEvaluationContext context) throws org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException, ServiceException {
        IEditorPart editor = ((ISashWindowsContainer)ServiceUtilsForIEvaluationContext.getInstance().getService(ISashWindowsContainer.class, (Object)context)).getActiveEditor();
        if (!(editor instanceof DiagramDocumentEditor)) {
            throw new org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException("Selected editor do not contains Diagram");
        }
        DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            throw new org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException("Selected editor do not contains Diagram");
        }
        return diagram;
    }

    protected boolean selectionFirstElementInstanceOf(List<Object> selections, Class<?> type) {
        if (selections.size() != 1) {
            return false;
        }
        Object first = selections.get(0);
        return type.isInstance(first);
    }
}

