/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.LinkLFNodeFigure;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editparts.AbstractBorderEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AffixedNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractElementBorderEditPart
extends AbstractBorderEditPart {
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public AbstractElementBorderEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DefaultGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected abstract LayoutEditPolicy createLayoutEditPolicy();

    protected IFigure createNodeShape() {
        this.primaryShape = new AffixedNamedElementFigure();
        return this.primaryShape;
    }

    public AffixedNamedElementFigure getPrimaryShape() {
        return (AffixedNamedElementFigure)this.primaryShape;
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    protected void handleNotificationEvent(Notification event) {
        if (NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature())) {
            Object notifier = event.getNotifier();
            EList modelChildren = ((View)this.getModel()).getChildren();
            if (!(notifier instanceof Edge) && modelChildren.contains(event.getNotifier())) {
                return;
            }
        }
        super.handleNotificationEvent(event);
    }

    protected void refreshBounds() {
        if (this.getBorderItemLocator() != null) {
            int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point loc = new Point(x, y);
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension size = new Dimension(width, height);
            IBorderItemLocator locator = this.getBorderItemLocator();
            locator.setConstraint(new Rectangle(loc, size));
            this.getFigure().getParent().setConstraint(this.getFigure(), (Object)locator);
        } else {
            super.refreshBounds();
        }
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = this.getNotationView().getType();
        IPreferenceStore store = Activator.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        LinkLFNodeFigure result = new LinkLFNodeFigure((GraphicalEditPart)this, store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        result.getBounds().setSize(result.getPreferredSize());
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    public abstract EditPart getPrimaryChildEditPart();

    public Object getPreferredValue(EStructuralFeature feature) {
        String prefKey = this.getNotationView().getType();
        IPreferenceStore store = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)prefKey, (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)prefKey, (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)prefKey, (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)store, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferencesConstantsHelper.getElementConstant((String)prefKey, (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }
}

