/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.architecture.internal.migration;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableReconciler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;

public class SysMLNeonToOxygenTableReconciler
extends TableReconciler {
    private static final String ALLOCATION_TABLE_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.nattable.allocation/resources/configuration/allocationTable.configuration#_j2LQIC7uEeWklMXvaoXzgQ";
    private static final String REQUIREMENT_TABLE_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.nattable.requirement/resources/configuration/requirementTable.configuration#_j2LQIy7uEeWklMXvaoXzgQ";
    private static final String REQUIREMENT_TREE_TABLE_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.nattable.requirement/resources/configuration/requirementTable.configuration#_eXTo8CywEeaHK-6t3D9x9w";

    public ICommand getReconcileCommand(Table table) {
        block14: {
            URI uri;
            PapyrusView oldTableKind;
            if (!(table.getPrototype() instanceof PapyrusView) || (oldTableKind = (PapyrusView)table.getPrototype()) == null || (uri = EcoreUtil.getURI((EObject)oldTableKind)) == null) break block14;
            PapyrusTable newTableKind = null;
            switch (uri.toString()) {
                case "platform:/plugin/org.eclipse.papyrus.sysml14.nattable.allocation/resources/configuration/allocationTable.configuration#_j2LQIC7uEeWklMXvaoXzgQ": {
                    newTableKind = this.getPapyrusTableById("org.eclipse.papyrus.sysml14.table.allocation");
                    break;
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.nattable.requirement/resources/configuration/requirementTable.configuration#_j2LQIy7uEeWklMXvaoXzgQ": {
                    newTableKind = this.getPapyrusTableById("org.eclipse.papyrus.sysml14.table.requirement");
                    break;
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.nattable.requirement/resources/configuration/requirementTable.configuration#_eXTo8CywEeaHK-6t3D9x9w": {
                    newTableKind = this.getPapyrusTableById("org.eclipse.papyrus.sysml14.table.requirementTree");
                    break;
                }
            }
            if (newTableKind != null) {
                return new ReplaceTablePrototypeCommand(table, (RepresentationKind)newTableKind);
            }
        }
        return null;
    }

    protected PapyrusTable getPapyrusTableById(String id) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        Collection visibleArchitectureContexts = manager.getVisibleArchitectureContexts();
        for (MergedArchitectureContext mergedArchitectureContext : visibleArchitectureContexts) {
            if (!(mergedArchitectureContext instanceof MergedArchitectureDescriptionLanguage)) continue;
            MergedArchitectureDescriptionLanguage mergedArchitectureDescriptionLanguage = (MergedArchitectureDescriptionLanguage)mergedArchitectureContext;
            for (RepresentationKind representationKind : mergedArchitectureDescriptionLanguage.getRepresentationKinds()) {
                if (!(representationKind instanceof PapyrusTable) || !representationKind.getId().equals(id)) continue;
                return (PapyrusTable)representationKind;
            }
        }
        return null;
    }

    protected class ReplaceTablePrototypeCommand
    extends AbstractCommand {
        private Table table;
        private RepresentationKind newKind;

        public ReplaceTablePrototypeCommand(Table table, RepresentationKind newKind) {
            super("Replace the SysML 1.4 Table configuration from neon to oxygen");
            this.table = table;
            this.newKind = newKind;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.table.setPrototype(null);
            this.table.setTableKindId(this.newKind.getId());
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

