/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Francois Le Fevre francois.le-fevre@cea.fr  - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.diagram.common.css.dom;

import org.eclipse.papyrus.infra.gmfdiag.css.engine.ICSSElementProviderFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.IPapyrusElementProvider;
import org.eclipse.papyrus.sysml14.util.SysMLResource;
import org.eclipse.uml2.uml.Element;


/**
 * IElementProvider Factory for Diagrams related to SysML Elements
 *
 * @author Francois Le Fevre
 *
 */
public class GMFSYSMLElementProviderFactory implements ICSSElementProviderFactory {

	@Override
	public boolean isProviderFor(CSSDiagram diagram) {
		if(diagram.getElement() instanceof Element){
			//Retrieve the UML2 element
			Element element = (Element)diagram.getElement();
			
			//Introspect its packages to check if SysML profile is applied
			return SysMLResource.isSysMLProfileApplied(element);	
		}
		return false;
	}

	@Override
	public IPapyrusElementProvider createProvider(CSSDiagram diagram) {
		return new GMFSYSMLElementProvider();
	}

	
	
}
