/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.utils;

import java.util.LinkedList;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;

public class NotationTypes {
    private static final double HIMETRIC_UNITS_PER_INCH = 2540.0;
    private static float pseudoHimetricDPI = 72.0f;
    private static double pseudoHimetricScale = 1.0;

    static {
        pseudoHimetricScale = (double)pseudoHimetricDPI / 2540.0;
    }

    @Operation(contextual=true, kind=Operation.Kind.QUERY)
    public static int toPixels(LayoutConstraint self, Integer himetric) {
        return himetric == null ? -1 : NotationTypes.convertToPixels(himetric);
    }

    @Operation(contextual=true, kind=Operation.Kind.QUERY)
    public static int toPixels(View self, Integer himetric) {
        return himetric == null ? -1 : NotationTypes.convertToPixels(himetric);
    }

    @Operation(contextual=true, kind=Operation.Kind.QUERY)
    public static int toPixels(Anchor self, Integer himetric) {
        return himetric == null ? -1 : NotationTypes.convertToPixels(himetric);
    }

    @Operation(contextual=true, kind=Operation.Kind.HELPER)
    public static void copyBendpoints(RelativeBendpoints source, RelativeBendpoints target, boolean convertToPixels) {
        LinkedList<RelativeBendpoint> result = new LinkedList<RelativeBendpoint>();
        for (Object point : source.getPoints()) {
            if (!(point instanceof RelativeBendpoint)) continue;
            RelativeBendpoint pointCopy = new RelativeBendpoint(((RelativeBendpoint)point).convertToString());
            result.add(pointCopy);
        }
        if (convertToPixels) {
            LinkedList<RelativeBendpoint> convertedResult = new LinkedList<RelativeBendpoint>();
            for (RelativeBendpoint point : result) {
                convertedResult.add(NotationTypes.convertToPixels(point));
            }
            result = convertedResult;
        }
        target.setPoints(result);
    }

    private static RelativeBendpoint convertToPixels(RelativeBendpoint bendpoint) {
        int newSourceX = NotationTypes.convertToPixels(bendpoint.getSourceX());
        int newSourceY = NotationTypes.convertToPixels(bendpoint.getSourceY());
        int newTargetX = NotationTypes.convertToPixels(bendpoint.getTargetX());
        int newTargetY = NotationTypes.convertToPixels(bendpoint.getTargetY());
        return new RelativeBendpoint(newSourceX, newSourceY, newTargetX, newTargetY);
    }

    private static int convertToPixels(int source) {
        return (int)((double)source * pseudoHimetricScale);
    }
}

