/*****************************************************************************
 * Copyright (c) 2021 Christian W. Damus, CEA LIST, and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.toolsmiths.validation.newchild.internal;

import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CommonProblemConstants;

/**
 * The element types plug-in validation constants.
 */
public class NewChildMenuPluginValidationConstants {

	/**
	 * The marker type for the validation of new child menu plugin.
	 */
	public static final String NEWCHILD_PLUGIN_VALIDATION_MARKER_TYPE = "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic"; //$NON-NLS-1$

	/**
	 * The extension point identifier for new child menu model files.
	 */
	public static final String NEWCHILD_EXTENSION_POINT_IDENTIFIER = "org.eclipse.papyrus.infra.newchild"; //$NON-NLS-1$

	/** The new child menu models extension point element name. */
	public static final String ELEM_MENU_CREATION_MODEL = "menuCreationModel"; //$NON-NLS-1$
	/** The new child menu models extension point attribute name for the model file path. */
	public static final String ATTR_MODEL = "model"; //$NON-NLS-1$

	/** Problem IDs for the markers generated by new child menu plug-in validation. */
	public static final int PROBLEM_ID_BASE = CommonProblemConstants.MAX_PROBLEM_ID + 0x01;
	public static final int MISSING_NEW_CHILD_MENU_MODEL_EXTENSION_ID = PROBLEM_ID_BASE + 0x00;
	public static final int MAX_PROBLEM_ID = PROBLEM_ID_BASE + 0x3f;

}
