/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.providers;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.RepresentationKind;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionSingleton;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionsRegistry;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class ExpandEditPartProvider
extends AbstractEditPartProvider {
    private static final String DEBUG_PREFIX = "[EXPANSION_DIAGRAM]";
    protected Map<String, Class<?>> nodeMap = new HashMap();
    protected Map<String, Class<?>> edgeMap = new HashMap();
    private DiagramExpansionsRegistry diagramExpansionRegistry = DiagramExpansionSingleton.getInstance().getDiagramExpansionRegistry();

    protected String getDiagramType(View currentView) {
        String currentDiagramType = null;
        Diagram diagram = currentView.getDiagram();
        if (diagram != null) {
            ViewPrototype viewPrototype = DiagramUtils.getPrototype((Diagram)diagram);
            currentDiagramType = viewPrototype != null ? viewPrototype.getLabel() : diagram.getType();
        }
        return currentDiagramType;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateGraphicEditPartOperation) {
            String currentDiagramType = this.getDiagramType(((IEditPartOperation)operation).getView());
            if (currentDiagramType == null || this.diagramExpansionRegistry.getUsage(currentDiagramType) == null) {
                return false;
            }
            if (operation instanceof CreateGraphicEditPartOperation) {
                View newView = ((IEditPartOperation)operation).getView();
                if (newView == null) {
                    return false;
                }
                String graphicalType = newView.getType();
                Activator.log.trace("expansion", ((Object)((Object)this)).getClass().getName() + " view appears with the type " + graphicalType);
                if (this.diagramExpansionRegistry.mapChildreen.get((Object)currentDiagramType).IDMap.get(graphicalType) != null) {
                    return true;
                }
            }
        }
        return super.provides(operation);
    }

    public IGraphicalEditPart createGraphicEditPart(View view) {
        IGraphicalEditPart graphicEditPart;
        String currentDiagramType = this.getDiagramType(view);
        if (currentDiagramType == null || this.diagramExpansionRegistry.getUsage(currentDiagramType) == null) {
            return null;
        }
        String graphicalType = view.getType();
        Activator.log.trace("expansion", ((Object)((Object)this)).getClass().getName() + " view appears with the type " + graphicalType);
        EObject eObject = this.diagramExpansionRegistry.mapChildreen.get((Object)currentDiagramType).IDMap.get(graphicalType);
        Class editpartClass = null;
        String editpartQualifiedName = null;
        if (eObject instanceof AbstractRepresentation) {
            editpartQualifiedName = ((AbstractRepresentation)eObject).getEditPartQualifiedName();
            if (editpartQualifiedName != null && !"".equals(editpartQualifiedName.trim())) {
                editpartClass = ClassLoaderHelper.loadClass((String)editpartQualifiedName);
            } else {
                RepresentationKind representationKind = ((AbstractRepresentation)eObject).getKind();
                if (representationKind != null && (editpartQualifiedName = representationKind.getEditPartQualifiedName()) != null) {
                    editpartClass = ClassLoaderHelper.loadClass((String)editpartQualifiedName);
                }
            }
        }
        if ((graphicEditPart = this.createNewGraphicEditPart(editpartClass, new Object[]{view})) == null) {
            String errorMessage = "The model expand does not reference an edit part for the element " + graphicalType;
            if (editpartQualifiedName != null) {
                errorMessage = "The editpart provide does not succed to find " + editpartQualifiedName + " class for the element " + graphicalType;
            }
            Activator.log.error(errorMessage, (Throwable)new NullPointerException(errorMessage));
        }
        return graphicEditPart;
    }

    private Constructor getCreationConstructor(Class editpartClass) {
        Constructor<?>[] consts;
        if (editpartClass != null && (consts = editpartClass.getConstructors()).length != 0) {
            return consts[0];
        }
        return null;
    }

    private IGraphicalEditPart createNewGraphicEditPart(Class editpartClass, Object[] constructorParams) {
        try {
            Constructor constructor = this.getCreationConstructor(editpartClass);
            return constructor == null ? null : (IGraphicalEditPart)constructor.newInstance(constructorParams);
        }
        catch (Throwable e) {
            String eMsg = NLS.bind((String)DiagramUIMessages.AbstractEditPartProvider_new_graphicaleditpart_failed_ERROR_, (Object)editpartClass);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)2, (String)eMsg, (Throwable)e);
            return null;
        }
    }
}

