/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.internal.ui.extensions;

import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;

public class ContextBindingsExtensionPoint {
    private static final String PREFPAGE_BINDING = "preferencePageBinding";
    private static final String CONTEXT = "context";
    private static final String PAGE = "page";
    private final String EXTENSION_ID = "org.eclipse.papyrus.infra.properties.ui.context";

    public ContextBindingsExtensionPoint(BiConsumer<String, String> bindingProcessor) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.properties.ui.context");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                switch (e.getName()) {
                    case "preferencePageBinding": {
                        this.processPrefPageBinding(e, bindingProcessor);
                    }
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
    }

    private void processPrefPageBinding(IConfigurationElement config, BiConsumer<String, String> bindingProcessor) {
        String page;
        boolean valid = true;
        String context = config.getAttribute(CONTEXT);
        if (context == null || context.isEmpty()) {
            valid = false;
            Activator.log.warn(String.format("Missing context name in preference page binding extension in plug-in %s", config.getContributor().getName()));
        }
        if ((page = config.getAttribute(PAGE)) == null || page.isEmpty()) {
            valid = false;
            Activator.log.warn(String.format("Missing page ID in preference page binding extension in plug-in %s", config.getContributor().getName()));
        }
        if (valid) {
            bindingProcessor.accept(context, page);
        }
    }
}

