/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.uml.comment.editor.newresource.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.papyrus.example.text.instance.papyrustextinstance.PapyrusTextInstance;
import org.eclipse.papyrus.example.uml.comment.editor.newresource.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.uml2.uml.Comment;

public class PapyrusCommentEditor
extends TextEditor {
    protected final ServicesRegistry registry;
    protected final PapyrusTextInstance papyrusTextInstance;
    protected ITextListener listener;
    protected TransactionalEditingDomain domain;
    public static final String EDITOR_DEFAULT_NAME = "Comment Editor New Resource";
    public static final String EDITOR_TYPE = "CommentEditorNewResource";

    public PapyrusCommentEditor(ServicesRegistry registry, PapyrusTextInstance papyrusTextInstance) {
        this.registry = registry;
        this.papyrusTextInstance = papyrusTextInstance;
        try {
            this.domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        this.listener = new ITextListener(){

            public void textChanged(TextEvent event) {
                SetRequest request;
                String currentText = PapyrusCommentEditor.this.getSourceViewer().getTextWidget().getText();
                Comment cmt = (Comment)PapyrusCommentEditor.this.papyrusTextInstance.getEditedObject();
                EStructuralFeature feature = cmt.eClass().getEStructuralFeature("body");
                IElementEditService elementEditService = ElementEditServiceUtils.getCommandProvider((EObject)cmt);
                ICommand command = elementEditService.getEditCommand((IEditCommandRequest)(request = new SetRequest(PapyrusCommentEditor.this.domain, (EObject)cmt, feature, (Object)currentText)));
                if (command.canExecute()) {
                    PapyrusCommentEditor.this.domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(command));
                }
            }
        };
        viewer.addTextListener(this.listener);
        return viewer;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        String string = ((Comment)this.papyrusTextInstance.getEditedObject()).getBody();
        if (string == null) {
            string = "";
        }
        TextStorage storage = new TextStorage(string);
        super.doSetInput((IEditorInput)new TextInput(storage));
    }

    public void dispose() {
        this.getSourceViewer().removeTextListener(this.listener);
        super.dispose();
    }

    class TextInput
    implements IStorageEditorInput {
        private IStorage storage;

        TextInput(IStorage storage) {
            this.storage = storage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.storage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() {
            return this.storage;
        }

        public String getToolTipText() {
            return "String-based file: " + this.storage.getName();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    class TextStorage
    implements IStorage {
        private String string;

        TextStorage(String input) {
            this.string = input;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.string.getBytes());
        }

        public IPath getFullPath() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getName() {
            int len = Math.min(5, this.string.length());
            return this.string.substring(0, len).concat("...");
        }

        public boolean isReadOnly() {
            return false;
        }
    }
}

