/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.checker.SemanticAndGraphicChecker;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.checker.SemanticAndGraphicalCreationChecker;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.uml2.uml.Package;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractCreateEdgeTests
extends AbstractSiriusDiagramTests {
    protected Package root;
    private EObject semanticSource;
    private EObject semanticTarget;
    private EObject edgeSource;
    private EObject edgeTarget;

    @Before
    public void setUp() {
        this.root = this.fixture.getModel();
    }

    protected void createEdge(String creationToolId, SemanticAndGraphicalCreationChecker checker) {
        this.createEdge(creationToolId, List.of(checker));
    }

    protected void createEdge(String creationToolId, List<SemanticAndGraphicalCreationChecker> checkers) {
        this.checkSiriusDiagramSynchronization(this.isSynchronization());
        Diagram diagram = this.getDiagram();
        ArrayList oldEdges = new ArrayList(diagram.getEdges());
        boolean result = this.applyCreationTool(creationToolId, (DDiagram)this.getDDiagram(), (EdgeTarget)this.getEdgeSource(), (EdgeTarget)this.getEdgeTarget());
        Assert.assertTrue((String)"The creation of edge failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        ArrayList newEdges = new ArrayList(diagram.getEdges());
        newEdges.removeAll(oldEdges);
        Assert.assertEquals((String)"Wrong number of created edges", (long)checkers.size(), (long)newEdges.size());
        int index = 0;
        while (index < checkers.size()) {
            Object gmfView = newEdges.get(index);
            Assert.assertTrue((String)"The created edge must be a GMF View", (boolean)(gmfView instanceof View));
            EObject edge = ((View)gmfView).getElement();
            Assert.assertTrue((String)"The created sirus edge must be an DEdge", (boolean)(edge instanceof DEdge));
            checkers.get(index).validateRepresentationElement((DRepresentationElement)((DEdge)edge));
            ++index;
        }
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        checkers.forEach(SemanticAndGraphicChecker::validateAfterUndo);
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        checkers.forEach(SemanticAndGraphicChecker::validateAfterRedo);
    }

    @After
    public void tearDown() {
        this.root = null;
    }

    public EObject getSemanticSource() {
        return this.semanticSource;
    }

    @Deprecated
    public void setSemanticSource(EObject semanticSource) {
        this.semanticSource = semanticSource;
    }

    public EObject getSemanticTarget() {
        return this.semanticTarget;
    }

    @Deprecated
    public void setSemanticTarget(EObject semanticTarget) {
        this.semanticTarget = semanticTarget;
    }

    public EObject getEdgeSource() {
        return this.edgeSource;
    }

    public void setEdgeSource(EObject edgeSource) {
        this.edgeSource = edgeSource;
    }

    public EObject getEdgeTarget() {
        return this.edgeTarget;
    }

    public void setEdgeTarget(EObject edgeTarget) {
        this.edgeTarget = edgeTarget;
    }

    protected boolean applyCreationTool(String creationToolId, DDiagram diagram, EdgeTarget edgeSource, EdgeTarget edgeTarget) {
        return this.fixture.applyEdgeCreationTool(creationToolId, (DDiagram)this.getDDiagram(), edgeSource, edgeTarget);
    }
}

