/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.CheckedDiagramCommandStack;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.DiagramReloadContextProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.PaletteViewerReloadContextProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.SemanticFromGMFElement;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.ReconcileHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SynchronizableGmfDiagramEditor
extends DiagramDocumentEditor
implements IRevealSemanticElement,
NavigationTarget {
    private Collection<PalettePageWrapper> palettePages;
    private Object palettePageState;

    public SynchronizableGmfDiagramEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public void dispose() {
        DiagramEditPart diagramEP = this.getDiagramEditPart();
        if (diagramEP != null) {
            EditPart editPart = diagramEP.getParent();
            if (editPart instanceof DiagramRootEditPart) {
                DiagramRootEditPart parent = (DiagramRootEditPart)editPart;
                parent.removeNotify();
            }
            this.deactivateNodeEditParts((EditPart)diagramEP);
        }
        super.dispose();
        if (this.palettePages != null) {
            this.palettePages.forEach(p -> p.dispose());
        }
    }

    private void deactivateNodeEditParts(EditPart ep) {
        for (EditPart child : ep.getChildren()) {
            this.deactivateNodeEditParts(child);
            child.setParent(null);
        }
        ep.deactivate();
        ep.getChildren().clear();
    }

    public void revealSemanticElement(List<?> elementList) {
        this.revealElement(elementList);
    }

    public boolean revealElement(Object element) {
        return this.revealElement(Collections.singleton(element));
    }

    public boolean revealElement(Collection<?> elementList) {
        SemanticFromGMFElement semanticFromGMFElement = new SemanticFromGMFElement();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        if (graphicalViewer != null) {
            Iterator iter = graphicalViewer.getEditPartRegistry().values().iterator();
            IGraphicalEditPart researchedEditPart = null;
            ArrayList clonedList = new ArrayList(elementList);
            ArrayList<IGraphicalEditPart> partSelection = new ArrayList<IGraphicalEditPart>();
            while (iter.hasNext() && !clonedList.isEmpty()) {
                Object currentElement;
                Object currentEditPart = iter.next();
                if (!(currentEditPart instanceof IPrimaryEditPart) || !clonedList.contains(currentElement = semanticFromGMFElement.getSemanticElement(currentEditPart))) continue;
                clonedList.remove(currentElement);
                researchedEditPart = (IGraphicalEditPart)currentEditPart;
                partSelection.add(researchedEditPart);
            }
            if (!clonedList.isEmpty()) {
                Iterator iterator = clonedList.iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (!graphicalViewer.getEditPartRegistry().containsKey(element) || clonedList.isEmpty()) continue;
                    iterator.remove();
                    researchedEditPart = (IGraphicalEditPart)graphicalViewer.getEditPartRegistry().get(element);
                    partSelection.add(researchedEditPart);
                }
            }
            if (clonedList.isEmpty() || clonedList.size() == 1 && clonedList.get(0) == this.getDiagram().getElement()) {
                StructuredSelection sSelection = new StructuredSelection(partSelection);
                graphicalViewer.setSelection((ISelection)sSelection);
                if (!partSelection.isEmpty()) {
                    graphicalViewer.reveal((EditPart)partSelection.get(0));
                }
                return true;
            }
        }
        return false;
    }

    public Object getAdapter(Class type) {
        if (type == DiagramEditPart.class) {
            return this.getDiagramEditPart();
        }
        if (type == Diagram.class) {
            return this.getDiagram();
        }
        if (type == IReloadContextProvider.class) {
            return new DiagramReloadContextProvider(this);
        }
        if (type == PalettePage.class) {
            if (this.palettePages == null) {
                this.palettePages = Lists.newArrayListWithExpectedSize((int)1);
            } else {
                this.cleanUpPalettePages();
                if (!this.palettePages.isEmpty()) {
                    ((PalettePageWrapper)Iterables.getLast(this.palettePages, null)).saveState();
                }
            }
            PalettePageWrapper result = new PalettePageWrapper((DiagramEditorWithFlyOutPalette.CustomPalettePage)super.getAdapter(type));
            this.palettePages.add(result);
            return result;
        }
        if (type == IContentOutlinePage.class) {
            Object result = super.getAdapter(type);
            if (result instanceof ContentOutlinePage) {
                result = new OutlinePageWrapper((ContentOutlinePage)result);
            }
            return result;
        }
        return super.getAdapter(type);
    }

    Collection<? extends PalettePage> getPalettePages() {
        if (this.palettePages == null) {
            return Collections.emptyList();
        }
        this.cleanUpPalettePages();
        return Collections.unmodifiableCollection(this.palettePages);
    }

    void setDeferredPalettePageReloadContext(Object reloadContext) {
        this.palettePageState = reloadContext;
    }

    private void cleanUpPalettePages() {
        Iterator<PalettePageWrapper> iter = this.palettePages.iterator();
        while (iter.hasNext()) {
            if (!iter.next().isDisposed()) continue;
            iter.remove();
        }
    }

    protected void configureDiagramEditDomain() {
        DefaultEditDomain editDomain = this.getEditDomain();
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            CheckedDiagramCommandStack diagramStack = new CheckedDiagramCommandStack(this.getDiagramEditDomain());
            editDomain.setCommandStack((CommandStack)diagramStack);
        }
        DiagramEditDomain diagEditDomain = (DiagramEditDomain)this.getDiagramEditDomain();
        diagEditDomain.setActionManager(this.createActionManager());
    }

    public void setFocus() {
        super.setFocus();
        this.updateToggleActionState();
    }

    protected void updateToggleActionState() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        if (commandService == null) {
            throw new RuntimeException(String.format("The Eclipse service %s has not been found", ICommandService.class));
        }
        IPreferenceStore wsPreferenceStore = ((DiagramGraphicalViewer)this.getDiagramGraphicalViewer()).getWorkspaceViewerPreferenceStore();
        Command command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.ViewGridCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("rulergrid.viewgrid"));
        command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.ViewRulersCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("rulergrid.viewrulers"));
        command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.ViewPageBreaksCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("viewpagebreaks"));
        command = commandService.getCommand("org.eclipse.papyrus.infra.gmfdiag.menu.SnapToGridCommand");
        EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)wsPreferenceStore.getBoolean("rulergrid.snaptogrid"));
    }

    protected void addDefaultPreferences() {
        super.addDefaultPreferences();
        PreferencesHint preferencesHint = this.getPreferencesHint();
        IPreferenceStore globalPreferenceStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Diagram diagram = this.getDiagram();
        String diagramType = diagram.getType();
        boolean viewGrid = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 24));
        boolean viewRuler = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 23));
        int rulerUnit = globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant(diagramType, 25));
        boolean snapToGrid = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 26));
        boolean snapToGeometry = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 27));
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)globalPreferenceStore, (String)PreferencesConstantsHelper.getDiagramConstant(diagramType, 28));
        int gridLineColor = FigureUtilities.RGBToInteger((RGB)rgb);
        double gridSpacing = globalPreferenceStore.getDouble(PreferencesConstantsHelper.getDiagramConstant(diagramType, 29));
        boolean gridOrder = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant(diagramType, 30));
        int gridLineStyle = globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant(diagramType, 31));
        PreferenceStore localStore = this.getWorkspaceViewerPreferenceStore();
        localStore.setValue("rulergrid.viewgrid", NotationUtils.getBooleanValue((View)diagram, "rulergrid.viewgrid", viewGrid));
        localStore.setValue("rulergrid.viewrulers", NotationUtils.getBooleanValue((View)diagram, "rulergrid.viewrulers", viewRuler));
        localStore.setValue("rulergrid.rulerunit", NotationUtils.getIntValue((View)diagram, "rulergrid.rulerunit", rulerUnit));
        localStore.setValue("rulergrid.snaptogrid", NotationUtils.getBooleanValue((View)diagram, "rulergrid.snaptogrid", snapToGrid));
        localStore.setValue("rulergrid.snaptogeometry", NotationUtils.getBooleanValue((View)diagram, "rulergrid.snaptogeometry", snapToGeometry));
        localStore.setValue("rulergrid.gridlinecolor", NotationUtils.getIntValue((View)diagram, "rulergrid.gridlinecolor", gridLineColor));
        localStore.setValue("rulergrid.gridspacing", NotationUtils.getDoubleValue((View)diagram, "rulergrid.gridspacing", gridSpacing));
        localStore.setValue("rulergrid.gridlevel", !NotationUtils.getBooleanValue((View)diagram, "rulergrid.gridlevel", gridOrder));
        localStore.setValue("rulergrid.gridlevel", NotationUtils.getBooleanValue((View)diagram, "rulergrid.gridlevel", gridOrder));
        localStore.setValue("rulergrid.gridlinestyle", NotationUtils.getIntValue((View)diagram, "rulergrid.gridlinestyle", gridLineStyle));
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        DiagramEditPart diagram = this.getDiagramEditPart();
        if (diagram != null) {
            try {
                ISyncService syncService = (ISyncService)ServiceUtilsForEditPart.getInstance().getService(ISyncService.class, diagram);
                syncService.evaluateTriggers((Object)diagram.getViewer());
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        super.doSetInput(input, releaseEditorContents);
        if (this.getDiagram() != null && !DiagramVersioningUtils.isOfCurrentPapyrusVersion(this.getDiagram())) {
            new ReconcileHelper(this.getEditingDomain()).reconcileDiagram(this.getDiagram());
        }
    }

    private class OutlinePageWrapper
    implements IPageBookViewPage,
    IContentOutlinePage {
        private final ContentOutlinePage delegate;

        OutlinePageWrapper(ContentOutlinePage delegate) {
            this.delegate = delegate;
        }

        public void createControl(Composite parent) {
            this.delegate.createControl(parent);
        }

        public void dispose() {
            try {
                IActionBars bars = this.getSite().getActionBars();
                bars.getToolBarManager().removeAll();
                bars.updateActionBars();
            }
            finally {
                this.delegate.dispose();
            }
        }

        public Control getControl() {
            return this.delegate.getControl();
        }

        public void setActionBars(IActionBars actionBars) {
            this.delegate.setActionBars(actionBars);
        }

        public void setFocus() {
            this.delegate.setFocus();
        }

        public void init(IPageSite site) throws PartInitException {
            this.delegate.init(site);
        }

        public IPageSite getSite() {
            return this.delegate.getSite();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.delegate.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            return this.delegate.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.delegate.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
            this.delegate.setSelection(selection);
        }
    }

    protected class PalettePageWrapper
    implements PalettePage,
    IAdaptable {
        private final DiagramEditorWithFlyOutPalette.CustomPalettePage delegate;
        private boolean disposed;

        protected PalettePageWrapper(DiagramEditorWithFlyOutPalette.CustomPalettePage delegate) {
            this.delegate = delegate;
        }

        public void createControl(Composite parent) {
            Control existing = this.getControl();
            if (existing != null && !existing.isDisposed()) {
                return;
            }
            this.delegate.createControl(parent);
            this.delegate.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PalettePageWrapper.this.disposed = true;
                    ((PalettePageWrapper)PalettePageWrapper.this).SynchronizableGmfDiagramEditor.this.palettePages.remove(PalettePageWrapper.this);
                }
            });
            if (SynchronizableGmfDiagramEditor.this.palettePageState != null) {
                PaletteViewerReloadContextProvider.getInstance(this.getPaletteViewer()).restore(SynchronizableGmfDiagramEditor.this.palettePageState);
                SynchronizableGmfDiagramEditor.this.palettePageState = null;
            }
        }

        public void dispose() {
            this.saveState();
            this.delegate.dispose();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        void saveState() {
            PaletteViewer palette = this.getPaletteViewer();
            if (palette != null) {
                SynchronizableGmfDiagramEditor.this.palettePageState = PaletteViewerReloadContextProvider.getInstance(palette).createReloadContext();
            }
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IReloadContextProvider.class) {
                return new IReloadContextProvider(){

                    public Object createReloadContext() {
                        return PalettePageWrapper.this.getPaletteViewer() != null ? PaletteViewerReloadContextProvider.getInstance(PalettePageWrapper.this.getPaletteViewer()).createReloadContext() : null;
                    }

                    public void restore(Object reloadContext) {
                        if (PalettePageWrapper.this.getPaletteViewer() != null) {
                            PaletteViewerReloadContextProvider.getInstance(PalettePageWrapper.this.getPaletteViewer()).restore(reloadContext);
                        } else {
                            ((PalettePageWrapper)PalettePageWrapper.this).SynchronizableGmfDiagramEditor.this.palettePageState = reloadContext;
                        }
                    }
                };
            }
            return this.delegate.getAdapter(adapter);
        }

        public Control getControl() {
            return this.delegate.getPaletteViewer() == null ? null : this.delegate.getControl();
        }

        public void setFocus() {
            this.delegate.setFocus();
        }

        public void setActionBars(IActionBars actionBars) {
            this.delegate.setActionBars(actionBars);
        }

        public void init(IPageSite pageSite) {
            this.delegate.init(pageSite);
        }

        public IPageSite getSite() {
            return this.delegate.getSite();
        }

        public PaletteViewer getPaletteViewer() {
            return this.delegate.getPaletteViewer();
        }
    }
}

