/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.MasterObjectAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.EObjectWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.IWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.NattablewrapperFactory;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;

public class MatrixTableWidgetModelManager
extends TreeNattableModelManager
implements IMatrixTableWidgetManager {
    public MatrixTableWidgetModelManager(Table rawModel, ISelectionExtractor selectionExtractor, boolean initializeListeners) {
        super(rawModel, selectionExtractor, initializeListeners);
    }

    public MatrixTableWidgetModelManager(Table rawModel, ISelectionExtractor selectionExtractor) {
        super(rawModel, selectionExtractor);
    }

    public MatrixTableWidgetModelManager(Table rawModel) {
        super(rawModel);
    }

    @Override
    public boolean canDropRowElement(Collection<Object> objectsToAdd) {
        return false;
    }

    @Override
    public boolean canDropColumnsElement(Collection<Object> objectsToAdd) {
        return false;
    }

    @Override
    public boolean canInvertAxis() {
        return false;
    }

    @Override
    public boolean canCreateColumnElement(String elementType) {
        return false;
    }

    @Override
    public boolean canCreateDestroyRowsAxis() {
        return false;
    }

    @Override
    public boolean canMoveColumns() {
        return false;
    }

    @Override
    public boolean canInsertRow(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    @Override
    public boolean canInsertColumns(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    @Override
    public boolean canMoveRows() {
        return false;
    }

    @Override
    public boolean canCreateRowElement(String elementType) {
        return false;
    }

    @Override
    public boolean canCreateDestroyColumnsAxis() {
        return false;
    }

    @Override
    public void addRowSources(Collection<Object> objectToAdd) {
        Command cmd = this.getAddRowSourcesCommand(objectToAdd);
        if (cmd != null && cmd.canExecute()) {
            this.getTableEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public void removeRowSources(Collection<Object> objectToRemove) {
        Command cmd = this.getRemoveRowSourcesCommand(objectToRemove);
        if (cmd != null && cmd.canExecute()) {
            this.getTableEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public void addColumnSources(Collection<Object> objectToAdd) {
        Command cmd = this.getAddColumnSourcesCommand(objectToAdd);
        if (cmd != null && cmd.canExecute()) {
            this.getTableEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public void removeColumnSources(Collection<Object> objectToRemove) {
        Command cmd = this.getRemoveColumnSourcesCommand(objectToRemove);
        if (cmd != null && cmd.canExecute()) {
            this.getTableEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public Command getAddRowSourcesCommand(Collection<Object> objectsToAdd) {
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<Object> wrappersToAdd = new ArrayList<Object>();
        for (Object current : objectsToAdd) {
            if (current instanceof IWrapper) {
                Object wrappedElement = ((IWrapper)current).getElement();
                if (wrappedElement != null) {
                    toAdd.add(wrappedElement);
                }
                wrappersToAdd.add((IWrapper)current);
                continue;
            }
            if (!(current instanceof EObject)) continue;
            toAdd.add(current);
            EObjectWrapper wrapper = NattablewrapperFactory.eINSTANCE.createEObjectWrapper();
            wrapper.setElement((EObject)current);
            wrappersToAdd.add(wrapper);
        }
        CompoundCommand cc = new CompoundCommand("Add Matrix Row Sources Command");
        cc.append(this.getAddRowElementCommand(toAdd));
        cc.append(AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)this.getTable().getCurrentRowAxisProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources(), wrappersToAdd));
        return cc.canExecute() ? cc : null;
    }

    @Override
    public Command getRemoveRowSourcesCommand(Collection<Object> objectsToRemove) {
        CompoundCommand cc = new CompoundCommand("Remove Matrix rows sources command");
        MasterObjectAxisProvider provider = (MasterObjectAxisProvider)this.getTable().getCurrentRowAxisProvider();
        ArrayList<Object> axisToRemove = new ArrayList<Object>();
        block0: for (Object current : objectsToRemove) {
            IWrapper wrapperToRemove = null;
            if (current instanceof IWrapper) {
                wrapperToRemove = (IWrapper)current;
            } else {
                for (IWrapper wrapper : provider.getSources()) {
                    if (wrapper.getElement() != current) continue;
                    wrapperToRemove = wrapper;
                    break;
                }
            }
            if (wrapperToRemove != null) {
                cc.append(RemoveCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)provider, (Object)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources(), (Object)wrapperToRemove));
            }
            if (wrapperToRemove == null) continue;
            Object wrappedObject = wrapperToRemove.getElement();
            for (IAxis iaxis : this.getRowAxisManager().getRepresentedContentProvider().getAxis()) {
                if (iaxis.getElement() != wrappedObject) continue;
                axisToRemove.add(iaxis);
                continue block0;
            }
        }
        if (axisToRemove.size() > 0) {
            cc.append(this.getRowAxisManager().getDestroyAxisCommand(this.getTableEditingDomain(), axisToRemove));
        }
        return cc.canExecute() ? cc : null;
    }

    @Override
    public Command getAddColumnSourcesCommand(Collection<Object> objectsToAdd) {
        ArrayList<Object> wrappersToAdd = new ArrayList<Object>();
        for (Object current : objectsToAdd) {
            if (current instanceof IWrapper) {
                wrappersToAdd.add((IWrapper)current);
                continue;
            }
            if (!(current instanceof EObject)) continue;
            EObjectWrapper wrapper = NattablewrapperFactory.eINSTANCE.createEObjectWrapper();
            wrapper.setElement((EObject)current);
            wrappersToAdd.add(wrapper);
        }
        CompoundCommand cc = new CompoundCommand("Add Matrix Column Sources Command");
        cc.append(AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)this.getTable().getCurrentColumnAxisProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources(), wrappersToAdd));
        return cc.canExecute() ? cc : null;
    }

    @Override
    public Command getRemoveColumnSourcesCommand(Collection<Object> objectsToRemove) {
        MasterObjectAxisProvider columnAxisProvider = (MasterObjectAxisProvider)this.getTable().getCurrentColumnAxisProvider();
        ArrayList<IWrapper> wrappersToRemove = new ArrayList<IWrapper>();
        for (Object current : objectsToRemove) {
            IWrapper wrapperObj = null;
            if (current instanceof IWrapper) {
                wrapperObj = (IWrapper)current;
            } else {
                for (IWrapper wrapper : columnAxisProvider.getSources()) {
                    if (wrapper.getElement() != current) continue;
                    wrapperObj = wrapper;
                    break;
                }
            }
            if (wrapperObj == null) continue;
            wrappersToRemove.add(wrapperObj);
        }
        CompoundCommand cc = new CompoundCommand("Remove Matrix Column Sources Command");
        cc.append(RemoveCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)columnAxisProvider, (Object)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources(), wrappersToRemove));
        return cc.canExecute() ? cc : null;
    }
}

