/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils.utils;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.internationalization.utils.QualifiedNameUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class LabelInternationalizationUtils {
    public static String getLabelWithoutSubstract(EObject eObject, boolean localize) {
        String result = null;
        try {
            InternationalizationModelResource internationalizationResource = LabelInternationalizationUtils.getInternationalizationModelResource(eObject.eResource());
            if (internationalizationResource != null) {
                result = internationalizationResource.getValueForEntryKey(eObject.eResource().getURI(), eObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void setLabel(EObject eObject, String value, Locale locale) {
        try {
            InternationalizationModelResource internationalizationResource = LabelInternationalizationUtils.getInternationalizationModelResource(eObject.eResource());
            EObject parentEObject = LabelInternationalizationUtils.getParentEObject(eObject);
            if (internationalizationResource != null) {
                Locale localeToUse = locale;
                if (localeToUse == null) {
                    localeToUse = InternationalizationPreferencesUtils.getLocalePreference((EObject)parentEObject);
                }
                internationalizationResource.setValue(parentEObject.eResource().getURI(), eObject, value, localeToUse);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Command getSetLabelCommand(EditingDomain domain, EObject eObject, String value, Locale locale) {
        UnexecutableCommand resultCommand = null;
        EObject parentEObject = LabelInternationalizationUtils.getParentEObject(eObject);
        try {
            InternationalizationModelResource internationalizationResource = LabelInternationalizationUtils.getInternationalizationModelResource(parentEObject.eResource());
            if (internationalizationResource != null) {
                Locale localeToUse = locale;
                if (localeToUse == null) {
                    localeToUse = InternationalizationPreferencesUtils.getLocalePreference((EObject)parentEObject);
                }
                resultCommand = internationalizationResource.getSetValueCommand(domain, parentEObject.eResource().getURI(), eObject, value, localeToUse);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultCommand != null ? resultCommand : UnexecutableCommand.INSTANCE;
    }

    public static InternationalizationEntry getInternationalizationEntry(EObject eObject, Object key) {
        return LabelInternationalizationUtils.getInternationalizationEntry(eObject, key, null);
    }

    public static InternationalizationEntry getInternationalizationEntry(EObject eObject, Object key, Locale locale) {
        EObject parent = LabelInternationalizationUtils.getParentEObject(eObject);
        if (parent != null) {
            Resource resource = parent.eResource();
            try {
                InternationalizationModelResource internationalizationResource = LabelInternationalizationUtils.getInternationalizationModelResource(resource);
                if (internationalizationResource != null && resource != null) {
                    if (locale == null) {
                        locale = InternationalizationPreferencesUtils.getLocalePreference((EObject)parent);
                    }
                    return internationalizationResource.getEntryForKey(resource.getURI(), key, locale);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Set<Locale> getAvailableLocales(Resource resource) {
        Set locales = null;
        try {
            InternationalizationModelResource internationalizationResource = LabelInternationalizationUtils.getInternationalizationModelResource(resource);
            locales = internationalizationResource.getAvailablePropertiesLocales(resource.getURI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locales != null ? locales : new HashSet();
    }

    public static InternationalizationModelResource getInternationalizationModelResource(Resource resource) throws ServiceException, NotFoundException {
        ServicesRegistry servicesRegistry = ServiceUtilsForResourceSet.getInstance().getServiceRegistry(resource.getResourceSet());
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        return (InternationalizationModelResource)modelSet.getModelChecked("org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel");
    }

    public static void managePartLabelSynchronizer(EObject eObject, IInternationalizationEditor editorPart) {
        try {
            InternationalizationModelResource internationalizationResource = LabelInternationalizationUtils.getInternationalizationModelResource(eObject.eResource());
            internationalizationResource.addEditorPartForEObject(eObject, editorPart);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static EObject getParentEObject(EObject eObject) {
        EObject parentEObject = eObject;
        if (eObject instanceof Table) {
            parentEObject = ((Table)eObject).getOwner();
            if (parentEObject == null) {
                parentEObject = ((Table)eObject).getContext();
            }
        } else if (eObject instanceof Diagram) {
            parentEObject = QualifiedNameUtils.getOwner((Diagram)((Diagram)eObject));
        }
        return parentEObject;
    }
}

